@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.ExtendedPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Extended Properties for Azure IaasVM Backup.
 * @property diskExclusionProperties Extended Properties for Disk Exclusion.
 * @property linuxVmApplicationName Linux VM name
 */
public data class ExtendedPropertiesArgs(
    public val diskExclusionProperties: Output<DiskExclusionPropertiesArgs>? = null,
    public val linuxVmApplicationName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.ExtendedPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.ExtendedPropertiesArgs =
        com.pulumi.azurenative.recoveryservices.inputs.ExtendedPropertiesArgs.builder()
            .diskExclusionProperties(
                diskExclusionProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .linuxVmApplicationName(linuxVmApplicationName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExtendedPropertiesArgs].
 */
@PulumiTagMarker
public class ExtendedPropertiesArgsBuilder internal constructor() {
    private var diskExclusionProperties: Output<DiskExclusionPropertiesArgs>? = null

    private var linuxVmApplicationName: Output<String>? = null

    /**
     * @param value Extended Properties for Disk Exclusion.
     */
    @JvmName("anbfehedrrlvytux")
    public suspend fun diskExclusionProperties(`value`: Output<DiskExclusionPropertiesArgs>) {
        this.diskExclusionProperties = value
    }

    /**
     * @param value Linux VM name
     */
    @JvmName("kspqybmcjghydlrc")
    public suspend fun linuxVmApplicationName(`value`: Output<String>) {
        this.linuxVmApplicationName = value
    }

    /**
     * @param value Extended Properties for Disk Exclusion.
     */
    @JvmName("nnfprlurxexpmrrk")
    public suspend fun diskExclusionProperties(`value`: DiskExclusionPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskExclusionProperties = mapped
    }

    /**
     * @param argument Extended Properties for Disk Exclusion.
     */
    @JvmName("wjulnpgphtnordak")
    public suspend
    fun diskExclusionProperties(argument: suspend DiskExclusionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = DiskExclusionPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.diskExclusionProperties = mapped
    }

    /**
     * @param value Linux VM name
     */
    @JvmName("crmckyttoksvhftc")
    public suspend fun linuxVmApplicationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linuxVmApplicationName = mapped
    }

    internal fun build(): ExtendedPropertiesArgs = ExtendedPropertiesArgs(
        diskExclusionProperties = diskExclusionProperties,
        linuxVmApplicationName = linuxVmApplicationName,
    )
}
