@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.GetProtectionContainerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property containerName Name of the container whose details need to be fetched.
 * @property fabricName Name of the fabric where the container belongs.
 * @property resourceGroupName The name of the resource group where the recovery services vault is present.
 * @property vaultName The name of the recovery services vault.
 */
public data class GetProtectionContainerPlainArgs(
    public val containerName: String,
    public val fabricName: String,
    public val resourceGroupName: String,
    public val vaultName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.GetProtectionContainerPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.GetProtectionContainerPlainArgs =
        com.pulumi.azurenative.recoveryservices.inputs.GetProtectionContainerPlainArgs.builder()
            .containerName(containerName.let({ args0 -> args0 }))
            .fabricName(fabricName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .vaultName(vaultName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProtectionContainerPlainArgs].
 */
@PulumiTagMarker
public class GetProtectionContainerPlainArgsBuilder internal constructor() {
    private var containerName: String? = null

    private var fabricName: String? = null

    private var resourceGroupName: String? = null

    private var vaultName: String? = null

    /**
     * @param value Name of the container whose details need to be fetched.
     */
    @JvmName("kbdvptchtoxhosyn")
    public suspend fun containerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.containerName = mapped
    }

    /**
     * @param value Name of the fabric where the container belongs.
     */
    @JvmName("nnowhvugnfgnbuvx")
    public suspend fun fabricName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.fabricName = mapped
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("oxkjwnstwysewcxx")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("orrjontwvowyxsmq")
    public suspend fun vaultName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vaultName = mapped
    }

    internal fun build(): GetProtectionContainerPlainArgs = GetProtectionContainerPlainArgs(
        containerName = containerName ?: throw PulumiNullFieldException("containerName"),
        fabricName = fabricName ?: throw PulumiNullFieldException("fabricName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        vaultName = vaultName ?: throw PulumiNullFieldException("vaultName"),
    )
}
