@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.GetProtectionIntentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property fabricName Fabric name associated with the backed up item.
 * @property intentObjectName Backed up item name whose details are to be fetched.
 * @property resourceGroupName The name of the resource group where the recovery services vault is present.
 * @property vaultName The name of the recovery services vault.
 */
public data class GetProtectionIntentPlainArgs(
    public val fabricName: String,
    public val intentObjectName: String,
    public val resourceGroupName: String,
    public val vaultName: String,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.GetProtectionIntentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.GetProtectionIntentPlainArgs =
        com.pulumi.azurenative.recoveryservices.inputs.GetProtectionIntentPlainArgs.builder()
            .fabricName(fabricName.let({ args0 -> args0 }))
            .intentObjectName(intentObjectName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .vaultName(vaultName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProtectionIntentPlainArgs].
 */
@PulumiTagMarker
public class GetProtectionIntentPlainArgsBuilder internal constructor() {
    private var fabricName: String? = null

    private var intentObjectName: String? = null

    private var resourceGroupName: String? = null

    private var vaultName: String? = null

    /**
     * @param value Fabric name associated with the backed up item.
     */
    @JvmName("gdkofxbukwianwvb")
    public suspend fun fabricName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.fabricName = mapped
    }

    /**
     * @param value Backed up item name whose details are to be fetched.
     */
    @JvmName("utrfjutwtyhvqolm")
    public suspend fun intentObjectName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.intentObjectName = mapped
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("iakbjetjjxpwjfyl")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("lxjtqaplvthbyxkf")
    public suspend fun vaultName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vaultName = mapped
    }

    internal fun build(): GetProtectionIntentPlainArgs = GetProtectionIntentPlainArgs(
        fabricName = fabricName ?: throw PulumiNullFieldException("fabricName"),
        intentObjectName = intentObjectName ?: throw PulumiNullFieldException("intentObjectName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        vaultName = vaultName ?: throw PulumiNullFieldException("vaultName"),
    )
}
