@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.GetProtectionPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property policyName Backup policy information to be fetched.
 * @property resourceGroupName The name of the resource group where the recovery services vault is present.
 * @property vaultName The name of the recovery services vault.
 */
public data class GetProtectionPolicyPlainArgs(
    public val policyName: String,
    public val resourceGroupName: String,
    public val vaultName: String,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.GetProtectionPolicyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.GetProtectionPolicyPlainArgs =
        com.pulumi.azurenative.recoveryservices.inputs.GetProtectionPolicyPlainArgs.builder()
            .policyName(policyName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .vaultName(vaultName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProtectionPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetProtectionPolicyPlainArgsBuilder internal constructor() {
    private var policyName: String? = null

    private var resourceGroupName: String? = null

    private var vaultName: String? = null

    /**
     * @param value Backup policy information to be fetched.
     */
    @JvmName("hktiauglxpeukoar")
    public suspend fun policyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.policyName = mapped
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("nxaleesnxmjgjpqs")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("iytohrwdemffabha")
    public suspend fun vaultName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vaultName = mapped
    }

    internal fun build(): GetProtectionPolicyPlainArgs = GetProtectionPolicyPlainArgs(
        policyName = policyName ?: throw PulumiNullFieldException("policyName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        vaultName = vaultName ?: throw PulumiNullFieldException("vaultName"),
    )
}
