@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.GetReplicationStorageClassificationMappingPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property fabricName Fabric name.
 * @property resourceGroupName The name of the resource group where the recovery services vault is present.
 * @property resourceName The name of the recovery services vault.
 * @property storageClassificationMappingName Storage classification mapping name.
 * @property storageClassificationName Storage classification name.
 */
public data class GetReplicationStorageClassificationMappingPlainArgs(
    public val fabricName: String,
    public val resourceGroupName: String,
    public val resourceName: String,
    public val storageClassificationMappingName: String,
    public val storageClassificationName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.GetReplicationStorageClassificationMappingPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.GetReplicationStorageClassificationMappingPlainArgs =
        com.pulumi.azurenative.recoveryservices.inputs.GetReplicationStorageClassificationMappingPlainArgs.builder()
            .fabricName(fabricName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 }))
            .storageClassificationMappingName(storageClassificationMappingName.let({ args0 -> args0 }))
            .storageClassificationName(storageClassificationName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetReplicationStorageClassificationMappingPlainArgs].
 */
@PulumiTagMarker
public class GetReplicationStorageClassificationMappingPlainArgsBuilder internal constructor() {
    private var fabricName: String? = null

    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    private var storageClassificationMappingName: String? = null

    private var storageClassificationName: String? = null

    /**
     * @param value Fabric name.
     */
    @JvmName("prmltpopwwhxumld")
    public suspend fun fabricName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.fabricName = mapped
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("hxibcsiprdxvlpde")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("gaepwfbxcdqlfqnp")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    /**
     * @param value Storage classification mapping name.
     */
    @JvmName("ykeyechglvkapgvx")
    public suspend fun storageClassificationMappingName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.storageClassificationMappingName = mapped
    }

    /**
     * @param value Storage classification name.
     */
    @JvmName("hrurmjahonressgi")
    public suspend fun storageClassificationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.storageClassificationName = mapped
    }

    internal fun build(): GetReplicationStorageClassificationMappingPlainArgs =
        GetReplicationStorageClassificationMappingPlainArgs(
            fabricName = fabricName ?: throw PulumiNullFieldException("fabricName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
            storageClassificationMappingName = storageClassificationMappingName ?: throw
                PulumiNullFieldException("storageClassificationMappingName"),
            storageClassificationName = storageClassificationName ?: throw
                PulumiNullFieldException("storageClassificationName"),
        )
}
