@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.InMageEnableProtectionInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * VMware Azure specific enable protection input.
 * @property datastoreName The target datastore name.
 * @property diskExclusionInput The enable disk exclusion input.
 * @property disksToInclude The disks to include list.
 * @property instanceType The class type.
 * Expected value is 'InMage'.
 * @property masterTargetId The Master Target Id.
 * @property multiVmGroupId The multi VM group Id.
 * @property multiVmGroupName The multi VM group name.
 * @property processServerId The Process Server Id.
 * @property retentionDrive The retention drive to use on the MT.
 * @property runAsAccountId The CS account Id.
 * @property vmFriendlyName The VM Name.
 */
public data class InMageEnableProtectionInputArgs(
    public val datastoreName: Output<String>? = null,
    public val diskExclusionInput: Output<InMageDiskExclusionInputArgs>? = null,
    public val disksToInclude: Output<List<String>>? = null,
    public val instanceType: Output<String>,
    public val masterTargetId: Output<String>,
    public val multiVmGroupId: Output<String>,
    public val multiVmGroupName: Output<String>,
    public val processServerId: Output<String>,
    public val retentionDrive: Output<String>,
    public val runAsAccountId: Output<String>? = null,
    public val vmFriendlyName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.InMageEnableProtectionInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.InMageEnableProtectionInputArgs =
        com.pulumi.azurenative.recoveryservices.inputs.InMageEnableProtectionInputArgs.builder()
            .datastoreName(datastoreName?.applyValue({ args0 -> args0 }))
            .diskExclusionInput(
                diskExclusionInput?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .disksToInclude(disksToInclude?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceType(instanceType.applyValue({ args0 -> args0 }))
            .masterTargetId(masterTargetId.applyValue({ args0 -> args0 }))
            .multiVmGroupId(multiVmGroupId.applyValue({ args0 -> args0 }))
            .multiVmGroupName(multiVmGroupName.applyValue({ args0 -> args0 }))
            .processServerId(processServerId.applyValue({ args0 -> args0 }))
            .retentionDrive(retentionDrive.applyValue({ args0 -> args0 }))
            .runAsAccountId(runAsAccountId?.applyValue({ args0 -> args0 }))
            .vmFriendlyName(vmFriendlyName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InMageEnableProtectionInputArgs].
 */
@PulumiTagMarker
public class InMageEnableProtectionInputArgsBuilder internal constructor() {
    private var datastoreName: Output<String>? = null

    private var diskExclusionInput: Output<InMageDiskExclusionInputArgs>? = null

    private var disksToInclude: Output<List<String>>? = null

    private var instanceType: Output<String>? = null

    private var masterTargetId: Output<String>? = null

    private var multiVmGroupId: Output<String>? = null

    private var multiVmGroupName: Output<String>? = null

    private var processServerId: Output<String>? = null

    private var retentionDrive: Output<String>? = null

    private var runAsAccountId: Output<String>? = null

    private var vmFriendlyName: Output<String>? = null

    /**
     * @param value The target datastore name.
     */
    @JvmName("axaudlflhvciynli")
    public suspend fun datastoreName(`value`: Output<String>) {
        this.datastoreName = value
    }

    /**
     * @param value The enable disk exclusion input.
     */
    @JvmName("rcdgspqyxnabyhrj")
    public suspend fun diskExclusionInput(`value`: Output<InMageDiskExclusionInputArgs>) {
        this.diskExclusionInput = value
    }

    /**
     * @param value The disks to include list.
     */
    @JvmName("rsrhekptldlljcqj")
    public suspend fun disksToInclude(`value`: Output<List<String>>) {
        this.disksToInclude = value
    }

    @JvmName("gjlwonpnnywaqhjh")
    public suspend fun disksToInclude(vararg values: Output<String>) {
        this.disksToInclude = Output.all(values.asList())
    }

    /**
     * @param values The disks to include list.
     */
    @JvmName("ttghhrnuteaaglvl")
    public suspend fun disksToInclude(values: List<Output<String>>) {
        this.disksToInclude = Output.all(values)
    }

    /**
     * @param value The class type.
     * Expected value is 'InMage'.
     */
    @JvmName("eupddejolebftcys")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The Master Target Id.
     */
    @JvmName("jffgdtqmfwsughyy")
    public suspend fun masterTargetId(`value`: Output<String>) {
        this.masterTargetId = value
    }

    /**
     * @param value The multi VM group Id.
     */
    @JvmName("rckvmfgixddbgpps")
    public suspend fun multiVmGroupId(`value`: Output<String>) {
        this.multiVmGroupId = value
    }

    /**
     * @param value The multi VM group name.
     */
    @JvmName("npwnvqujcalkfidd")
    public suspend fun multiVmGroupName(`value`: Output<String>) {
        this.multiVmGroupName = value
    }

    /**
     * @param value The Process Server Id.
     */
    @JvmName("tkhvjffcxhwllcks")
    public suspend fun processServerId(`value`: Output<String>) {
        this.processServerId = value
    }

    /**
     * @param value The retention drive to use on the MT.
     */
    @JvmName("jdpqjgcldiwrceds")
    public suspend fun retentionDrive(`value`: Output<String>) {
        this.retentionDrive = value
    }

    /**
     * @param value The CS account Id.
     */
    @JvmName("tuwgtkgeghnbsedg")
    public suspend fun runAsAccountId(`value`: Output<String>) {
        this.runAsAccountId = value
    }

    /**
     * @param value The VM Name.
     */
    @JvmName("jwrwimjnisnwjjrr")
    public suspend fun vmFriendlyName(`value`: Output<String>) {
        this.vmFriendlyName = value
    }

    /**
     * @param value The target datastore name.
     */
    @JvmName("hiptancgeuykwkrl")
    public suspend fun datastoreName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datastoreName = mapped
    }

    /**
     * @param value The enable disk exclusion input.
     */
    @JvmName("iqdhjqgjljdhqxgt")
    public suspend fun diskExclusionInput(`value`: InMageDiskExclusionInputArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskExclusionInput = mapped
    }

    /**
     * @param argument The enable disk exclusion input.
     */
    @JvmName("upwtaqayspumvqfo")
    public suspend
    fun diskExclusionInput(argument: suspend InMageDiskExclusionInputArgsBuilder.() -> Unit) {
        val toBeMapped = InMageDiskExclusionInputArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.diskExclusionInput = mapped
    }

    /**
     * @param value The disks to include list.
     */
    @JvmName("aohssrpymjbssjsm")
    public suspend fun disksToInclude(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disksToInclude = mapped
    }

    /**
     * @param values The disks to include list.
     */
    @JvmName("jlsjrdwdwfrnated")
    public suspend fun disksToInclude(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.disksToInclude = mapped
    }

    /**
     * @param value The class type.
     * Expected value is 'InMage'.
     */
    @JvmName("vbridfwxwkfoxfah")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The Master Target Id.
     */
    @JvmName("xrfkxflvcbhmypoc")
    public suspend fun masterTargetId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.masterTargetId = mapped
    }

    /**
     * @param value The multi VM group Id.
     */
    @JvmName("djxtnfarjpjjyomt")
    public suspend fun multiVmGroupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.multiVmGroupId = mapped
    }

    /**
     * @param value The multi VM group name.
     */
    @JvmName("vakpuavvhgbpfcra")
    public suspend fun multiVmGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.multiVmGroupName = mapped
    }

    /**
     * @param value The Process Server Id.
     */
    @JvmName("vbqhnmrmakrpgvyy")
    public suspend fun processServerId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.processServerId = mapped
    }

    /**
     * @param value The retention drive to use on the MT.
     */
    @JvmName("wrkyebvriskarxwi")
    public suspend fun retentionDrive(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.retentionDrive = mapped
    }

    /**
     * @param value The CS account Id.
     */
    @JvmName("kmwcghrsuggghgef")
    public suspend fun runAsAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runAsAccountId = mapped
    }

    /**
     * @param value The VM Name.
     */
    @JvmName("dwoundklcogwpxhp")
    public suspend fun vmFriendlyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmFriendlyName = mapped
    }

    internal fun build(): InMageEnableProtectionInputArgs = InMageEnableProtectionInputArgs(
        datastoreName = datastoreName,
        diskExclusionInput = diskExclusionInput,
        disksToInclude = disksToInclude,
        instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
        masterTargetId = masterTargetId ?: throw PulumiNullFieldException("masterTargetId"),
        multiVmGroupId = multiVmGroupId ?: throw PulumiNullFieldException("multiVmGroupId"),
        multiVmGroupName = multiVmGroupName ?: throw PulumiNullFieldException("multiVmGroupName"),
        processServerId = processServerId ?: throw PulumiNullFieldException("processServerId"),
        retentionDrive = retentionDrive ?: throw PulumiNullFieldException("retentionDrive"),
        runAsAccountId = runAsAccountId,
        vmFriendlyName = vmFriendlyName,
    )
}
