@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.InquiryInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Details about inquired protectable items under a given container.
 * @property inquiryDetails Inquiry Details which will have workload specific details.
 * For e.g. - For SQL and oracle this will contain different details.
 * @property status Inquiry Status for this container such as
 * InProgress | Failed | Succeeded
 */
public data class InquiryInfoArgs(
    public val inquiryDetails: Output<List<WorkloadInquiryDetailsArgs>>? = null,
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.InquiryInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.InquiryInfoArgs =
        com.pulumi.azurenative.recoveryservices.inputs.InquiryInfoArgs.builder()
            .inquiryDetails(
                inquiryDetails?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InquiryInfoArgs].
 */
@PulumiTagMarker
public class InquiryInfoArgsBuilder internal constructor() {
    private var inquiryDetails: Output<List<WorkloadInquiryDetailsArgs>>? = null

    private var status: Output<String>? = null

    /**
     * @param value Inquiry Details which will have workload specific details.
     * For e.g. - For SQL and oracle this will contain different details.
     */
    @JvmName("yhqiuaplylcxnxtl")
    public suspend fun inquiryDetails(`value`: Output<List<WorkloadInquiryDetailsArgs>>) {
        this.inquiryDetails = value
    }

    @JvmName("xpmkinxdyphlnucv")
    public suspend fun inquiryDetails(vararg values: Output<WorkloadInquiryDetailsArgs>) {
        this.inquiryDetails = Output.all(values.asList())
    }

    /**
     * @param values Inquiry Details which will have workload specific details.
     * For e.g. - For SQL and oracle this will contain different details.
     */
    @JvmName("qkseawjewgtaqulg")
    public suspend fun inquiryDetails(values: List<Output<WorkloadInquiryDetailsArgs>>) {
        this.inquiryDetails = Output.all(values)
    }

    /**
     * @param value Inquiry Status for this container such as
     * InProgress | Failed | Succeeded
     */
    @JvmName("fxytptrrevxcvcaf")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Inquiry Details which will have workload specific details.
     * For e.g. - For SQL and oracle this will contain different details.
     */
    @JvmName("bgssogqtcbuymvox")
    public suspend fun inquiryDetails(`value`: List<WorkloadInquiryDetailsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inquiryDetails = mapped
    }

    /**
     * @param argument Inquiry Details which will have workload specific details.
     * For e.g. - For SQL and oracle this will contain different details.
     */
    @JvmName("utmeilhgrujmfjbg")
    public suspend
    fun inquiryDetails(argument: List<suspend WorkloadInquiryDetailsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WorkloadInquiryDetailsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.inquiryDetails = mapped
    }

    /**
     * @param argument Inquiry Details which will have workload specific details.
     * For e.g. - For SQL and oracle this will contain different details.
     */
    @JvmName("dilolekjbvrbvjmx")
    public suspend fun inquiryDetails(
        vararg
        argument: suspend WorkloadInquiryDetailsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WorkloadInquiryDetailsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.inquiryDetails = mapped
    }

    /**
     * @param argument Inquiry Details which will have workload specific details.
     * For e.g. - For SQL and oracle this will contain different details.
     */
    @JvmName("gjngriuffmuopfyq")
    public suspend
    fun inquiryDetails(argument: suspend WorkloadInquiryDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(WorkloadInquiryDetailsArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.inquiryDetails = mapped
    }

    /**
     * @param values Inquiry Details which will have workload specific details.
     * For e.g. - For SQL and oracle this will contain different details.
     */
    @JvmName("lxebnudcsmhbgrod")
    public suspend fun inquiryDetails(vararg values: WorkloadInquiryDetailsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inquiryDetails = mapped
    }

    /**
     * @param value Inquiry Status for this container such as
     * InProgress | Failed | Succeeded
     */
    @JvmName("klonpkmjkefstlbp")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): InquiryInfoArgs = InquiryInfoArgs(
        inquiryDetails = inquiryDetails,
        status = status,
    )
}
