@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.InquiryValidationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Validation for inquired protectable items under a given container.
 * @property status Status for the Inquiry Validation.
 */
public data class InquiryValidationArgs(
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.InquiryValidationArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.InquiryValidationArgs =
        com.pulumi.azurenative.recoveryservices.inputs.InquiryValidationArgs.builder()
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InquiryValidationArgs].
 */
@PulumiTagMarker
public class InquiryValidationArgsBuilder internal constructor() {
    private var status: Output<String>? = null

    /**
     * @param value Status for the Inquiry Validation.
     */
    @JvmName("npjecfeusyrfxoed")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Status for the Inquiry Validation.
     */
    @JvmName("uxayiskgesglvxch")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): InquiryValidationArgs = InquiryValidationArgs(
        status = status,
    )
}
