@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.MonitoringSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Monitoring Settings of the vault
 * @property azureMonitorAlertSettings Settings for Azure Monitor based alerts
 * @property classicAlertSettings Settings for classic alerts
 */
public data class MonitoringSettingsArgs(
    public val azureMonitorAlertSettings: Output<AzureMonitorAlertSettingsArgs>? = null,
    public val classicAlertSettings: Output<ClassicAlertSettingsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.MonitoringSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.MonitoringSettingsArgs =
        com.pulumi.azurenative.recoveryservices.inputs.MonitoringSettingsArgs.builder()
            .azureMonitorAlertSettings(
                azureMonitorAlertSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .classicAlertSettings(
                classicAlertSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [MonitoringSettingsArgs].
 */
@PulumiTagMarker
public class MonitoringSettingsArgsBuilder internal constructor() {
    private var azureMonitorAlertSettings: Output<AzureMonitorAlertSettingsArgs>? = null

    private var classicAlertSettings: Output<ClassicAlertSettingsArgs>? = null

    /**
     * @param value Settings for Azure Monitor based alerts
     */
    @JvmName("ffyhtixfkjoxqjnq")
    public suspend fun azureMonitorAlertSettings(`value`: Output<AzureMonitorAlertSettingsArgs>) {
        this.azureMonitorAlertSettings = value
    }

    /**
     * @param value Settings for classic alerts
     */
    @JvmName("jmiymjpkwnsjbkrr")
    public suspend fun classicAlertSettings(`value`: Output<ClassicAlertSettingsArgs>) {
        this.classicAlertSettings = value
    }

    /**
     * @param value Settings for Azure Monitor based alerts
     */
    @JvmName("fafipudluxatnjir")
    public suspend fun azureMonitorAlertSettings(`value`: AzureMonitorAlertSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureMonitorAlertSettings = mapped
    }

    /**
     * @param argument Settings for Azure Monitor based alerts
     */
    @JvmName("twekhyusvjigeqor")
    public suspend
    fun azureMonitorAlertSettings(argument: suspend AzureMonitorAlertSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = AzureMonitorAlertSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.azureMonitorAlertSettings = mapped
    }

    /**
     * @param value Settings for classic alerts
     */
    @JvmName("mreteprjddcomyfx")
    public suspend fun classicAlertSettings(`value`: ClassicAlertSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.classicAlertSettings = mapped
    }

    /**
     * @param argument Settings for classic alerts
     */
    @JvmName("ccvafevmarjxwffc")
    public suspend
    fun classicAlertSettings(argument: suspend ClassicAlertSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ClassicAlertSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.classicAlertSettings = mapped
    }

    internal fun build(): MonitoringSettingsArgs = MonitoringSettingsArgs(
        azureMonitorAlertSettings = azureMonitorAlertSettings,
        classicAlertSettings = classicAlertSettings,
    )
}
