@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.RecoveryPlanA2AInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Recovery plan A2A input.
 * @property instanceType Gets the Instance type.
 * Expected value is 'A2A'.
 * @property primaryExtendedLocation The primary extended location.
 * @property primaryZone The primary zone.
 * @property recoveryExtendedLocation The recovery extended location.
 * @property recoveryZone The recovery zone.
 */
public data class RecoveryPlanA2AInputArgs(
    public val instanceType: Output<String>,
    public val primaryExtendedLocation: Output<ExtendedLocationArgs>? = null,
    public val primaryZone: Output<String>? = null,
    public val recoveryExtendedLocation: Output<ExtendedLocationArgs>? = null,
    public val recoveryZone: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.RecoveryPlanA2AInputArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.RecoveryPlanA2AInputArgs =
        com.pulumi.azurenative.recoveryservices.inputs.RecoveryPlanA2AInputArgs.builder()
            .instanceType(instanceType.applyValue({ args0 -> args0 }))
            .primaryExtendedLocation(
                primaryExtendedLocation?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .primaryZone(primaryZone?.applyValue({ args0 -> args0 }))
            .recoveryExtendedLocation(
                recoveryExtendedLocation?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .recoveryZone(recoveryZone?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RecoveryPlanA2AInputArgs].
 */
@PulumiTagMarker
public class RecoveryPlanA2AInputArgsBuilder internal constructor() {
    private var instanceType: Output<String>? = null

    private var primaryExtendedLocation: Output<ExtendedLocationArgs>? = null

    private var primaryZone: Output<String>? = null

    private var recoveryExtendedLocation: Output<ExtendedLocationArgs>? = null

    private var recoveryZone: Output<String>? = null

    /**
     * @param value Gets the Instance type.
     * Expected value is 'A2A'.
     */
    @JvmName("girmnkwpsfecqils")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The primary extended location.
     */
    @JvmName("sbtwjalmcwtloduj")
    public suspend fun primaryExtendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.primaryExtendedLocation = value
    }

    /**
     * @param value The primary zone.
     */
    @JvmName("xyfdhjbfeipgemok")
    public suspend fun primaryZone(`value`: Output<String>) {
        this.primaryZone = value
    }

    /**
     * @param value The recovery extended location.
     */
    @JvmName("qgjvwgjmlbvmuvmd")
    public suspend fun recoveryExtendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.recoveryExtendedLocation = value
    }

    /**
     * @param value The recovery zone.
     */
    @JvmName("kbwsnhnhjshvvlse")
    public suspend fun recoveryZone(`value`: Output<String>) {
        this.recoveryZone = value
    }

    /**
     * @param value Gets the Instance type.
     * Expected value is 'A2A'.
     */
    @JvmName("igesymofddekcnhd")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The primary extended location.
     */
    @JvmName("eejmewnlgbnoegam")
    public suspend fun primaryExtendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryExtendedLocation = mapped
    }

    /**
     * @param argument The primary extended location.
     */
    @JvmName("jtpymbtrdouycmsk")
    public suspend
    fun primaryExtendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.primaryExtendedLocation = mapped
    }

    /**
     * @param value The primary zone.
     */
    @JvmName("flokbeelvvprusas")
    public suspend fun primaryZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryZone = mapped
    }

    /**
     * @param value The recovery extended location.
     */
    @JvmName("wrkrquxhksdrwuwt")
    public suspend fun recoveryExtendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryExtendedLocation = mapped
    }

    /**
     * @param argument The recovery extended location.
     */
    @JvmName("fypquqdsfsnmbucj")
    public suspend
    fun recoveryExtendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.recoveryExtendedLocation = mapped
    }

    /**
     * @param value The recovery zone.
     */
    @JvmName("xegjxswlttdpxxps")
    public suspend fun recoveryZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryZone = mapped
    }

    internal fun build(): RecoveryPlanA2AInputArgs = RecoveryPlanA2AInputArgs(
        instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
        primaryExtendedLocation = primaryExtendedLocation,
        primaryZone = primaryZone,
        recoveryExtendedLocation = recoveryExtendedLocation,
        recoveryZone = recoveryZone,
    )
}
