@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.RecoveryPlanAutomationRunbookActionDetailsArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.RecoveryPlanActionLocation
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Recovery plan Automation runbook action details.
 * @property fabricLocation The fabric location.
 * @property instanceType Gets the type of action details (see RecoveryPlanActionDetailsTypes enum for possible values).
 * Expected value is 'AutomationRunbookActionDetails'.
 * @property runbookId The runbook ARM Id.
 * @property timeout The runbook timeout.
 */
public data class RecoveryPlanAutomationRunbookActionDetailsArgs(
    public val fabricLocation: Output<Either<String, RecoveryPlanActionLocation>>,
    public val instanceType: Output<String>,
    public val runbookId: Output<String>? = null,
    public val timeout: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.RecoveryPlanAutomationRunbookActionDetailsArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.RecoveryPlanAutomationRunbookActionDetailsArgs =
        com.pulumi.azurenative.recoveryservices.inputs.RecoveryPlanAutomationRunbookActionDetailsArgs.builder()
            .fabricLocation(
                fabricLocation.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .instanceType(instanceType.applyValue({ args0 -> args0 }))
            .runbookId(runbookId?.applyValue({ args0 -> args0 }))
            .timeout(timeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RecoveryPlanAutomationRunbookActionDetailsArgs].
 */
@PulumiTagMarker
public class RecoveryPlanAutomationRunbookActionDetailsArgsBuilder internal constructor() {
    private var fabricLocation: Output<Either<String, RecoveryPlanActionLocation>>? = null

    private var instanceType: Output<String>? = null

    private var runbookId: Output<String>? = null

    private var timeout: Output<String>? = null

    /**
     * @param value The fabric location.
     */
    @JvmName("uiqwkldevgyuywao")
    public suspend fun fabricLocation(`value`: Output<Either<String, RecoveryPlanActionLocation>>) {
        this.fabricLocation = value
    }

    /**
     * @param value Gets the type of action details (see RecoveryPlanActionDetailsTypes enum for possible values).
     * Expected value is 'AutomationRunbookActionDetails'.
     */
    @JvmName("jcsvkgtfwfjdupwg")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The runbook ARM Id.
     */
    @JvmName("tqwkwnjvwpfevgnh")
    public suspend fun runbookId(`value`: Output<String>) {
        this.runbookId = value
    }

    /**
     * @param value The runbook timeout.
     */
    @JvmName("enjjlccuanccduuc")
    public suspend fun timeout(`value`: Output<String>) {
        this.timeout = value
    }

    /**
     * @param value The fabric location.
     */
    @JvmName("rksianjudiansnai")
    public suspend fun fabricLocation(`value`: Either<String, RecoveryPlanActionLocation>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fabricLocation = mapped
    }

    /**
     * @param value The fabric location.
     */
    @JvmName("dmwdyipliiufcjoe")
    public fun fabricLocation(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RecoveryPlanActionLocation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fabricLocation = mapped
    }

    /**
     * @param value The fabric location.
     */
    @JvmName("xruabfrwdbivoeou")
    public fun fabricLocation(`value`: RecoveryPlanActionLocation) {
        val toBeMapped = Either.ofRight<String, RecoveryPlanActionLocation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fabricLocation = mapped
    }

    /**
     * @param value Gets the type of action details (see RecoveryPlanActionDetailsTypes enum for possible values).
     * Expected value is 'AutomationRunbookActionDetails'.
     */
    @JvmName("vgspgpxwcmkkjytn")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The runbook ARM Id.
     */
    @JvmName("krvohlenmnikigdu")
    public suspend fun runbookId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runbookId = mapped
    }

    /**
     * @param value The runbook timeout.
     */
    @JvmName("mcnrjsdwhtpdiite")
    public suspend fun timeout(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    internal fun build(): RecoveryPlanAutomationRunbookActionDetailsArgs =
        RecoveryPlanAutomationRunbookActionDetailsArgs(
            fabricLocation = fabricLocation ?: throw PulumiNullFieldException("fabricLocation"),
            instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
            runbookId = runbookId,
            timeout = timeout,
        )
}
