@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.RecoveryPlanManualActionDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Recovery plan manual action details.
 * @property description The manual action description.
 * @property instanceType Gets the type of action details (see RecoveryPlanActionDetailsTypes enum for possible values).
 * Expected value is 'ManualActionDetails'.
 */
public data class RecoveryPlanManualActionDetailsArgs(
    public val description: Output<String>? = null,
    public val instanceType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.RecoveryPlanManualActionDetailsArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.RecoveryPlanManualActionDetailsArgs =
        com.pulumi.azurenative.recoveryservices.inputs.RecoveryPlanManualActionDetailsArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RecoveryPlanManualActionDetailsArgs].
 */
@PulumiTagMarker
public class RecoveryPlanManualActionDetailsArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var instanceType: Output<String>? = null

    /**
     * @param value The manual action description.
     */
    @JvmName("slfrbxtmpfamlynr")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Gets the type of action details (see RecoveryPlanActionDetailsTypes enum for possible values).
     * Expected value is 'ManualActionDetails'.
     */
    @JvmName("yshqvvpcjmpoyekq")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The manual action description.
     */
    @JvmName("kjcjfftnfhboagrs")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Gets the type of action details (see RecoveryPlanActionDetailsTypes enum for possible values).
     * Expected value is 'ManualActionDetails'.
     */
    @JvmName("stqqggenvoawnbjm")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    internal fun build(): RecoveryPlanManualActionDetailsArgs = RecoveryPlanManualActionDetailsArgs(
        description = description,
        instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
    )
}
