@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.RecoveryPlanProtectedItemArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Recovery plan protected item.
 * @property id The ARM Id of the recovery plan protected item.
 * @property virtualMachineId The virtual machine Id.
 */
public data class RecoveryPlanProtectedItemArgs(
    public val id: Output<String>? = null,
    public val virtualMachineId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.RecoveryPlanProtectedItemArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.RecoveryPlanProtectedItemArgs =
        com.pulumi.azurenative.recoveryservices.inputs.RecoveryPlanProtectedItemArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .virtualMachineId(virtualMachineId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RecoveryPlanProtectedItemArgs].
 */
@PulumiTagMarker
public class RecoveryPlanProtectedItemArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var virtualMachineId: Output<String>? = null

    /**
     * @param value The ARM Id of the recovery plan protected item.
     */
    @JvmName("qdhiefixdpqbxead")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The virtual machine Id.
     */
    @JvmName("tdtapcddpohtrojd")
    public suspend fun virtualMachineId(`value`: Output<String>) {
        this.virtualMachineId = value
    }

    /**
     * @param value The ARM Id of the recovery plan protected item.
     */
    @JvmName("lfstfyngjlqbpvdi")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The virtual machine Id.
     */
    @JvmName("wkwdcachfnlyvbmm")
    public suspend fun virtualMachineId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualMachineId = mapped
    }

    internal fun build(): RecoveryPlanProtectedItemArgs = RecoveryPlanProtectedItemArgs(
        id = id,
        virtualMachineId = virtualMachineId,
    )
}
