@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.SimpleSchedulePolicyArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.DayOfWeek
import com.pulumi.azurenative.recoveryservices.kotlin.enums.ScheduleRunType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Simple policy schedule.
 * @property hourlySchedule Hourly Schedule of this Policy
 * @property schedulePolicyType This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
 * Expected value is 'SimpleSchedulePolicy'.
 * @property scheduleRunDays List of days of week this schedule has to be run.
 * @property scheduleRunFrequency Frequency of the schedule operation of this policy.
 * @property scheduleRunTimes List of times of day this schedule has to be run.
 * @property scheduleWeeklyFrequency At every number weeks this schedule has to be run.
 */
public data class SimpleSchedulePolicyArgs(
    public val hourlySchedule: Output<HourlyScheduleArgs>? = null,
    public val schedulePolicyType: Output<String>,
    public val scheduleRunDays: Output<List<DayOfWeek>>? = null,
    public val scheduleRunFrequency: Output<Either<String, ScheduleRunType>>? = null,
    public val scheduleRunTimes: Output<List<String>>? = null,
    public val scheduleWeeklyFrequency: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.SimpleSchedulePolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.SimpleSchedulePolicyArgs =
        com.pulumi.azurenative.recoveryservices.inputs.SimpleSchedulePolicyArgs.builder()
            .hourlySchedule(hourlySchedule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .schedulePolicyType(schedulePolicyType.applyValue({ args0 -> args0 }))
            .scheduleRunDays(
                scheduleRunDays?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .scheduleRunFrequency(
                scheduleRunFrequency?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .scheduleRunTimes(scheduleRunTimes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .scheduleWeeklyFrequency(scheduleWeeklyFrequency?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SimpleSchedulePolicyArgs].
 */
@PulumiTagMarker
public class SimpleSchedulePolicyArgsBuilder internal constructor() {
    private var hourlySchedule: Output<HourlyScheduleArgs>? = null

    private var schedulePolicyType: Output<String>? = null

    private var scheduleRunDays: Output<List<DayOfWeek>>? = null

    private var scheduleRunFrequency: Output<Either<String, ScheduleRunType>>? = null

    private var scheduleRunTimes: Output<List<String>>? = null

    private var scheduleWeeklyFrequency: Output<Int>? = null

    /**
     * @param value Hourly Schedule of this Policy
     */
    @JvmName("uqeuugocojdktgah")
    public suspend fun hourlySchedule(`value`: Output<HourlyScheduleArgs>) {
        this.hourlySchedule = value
    }

    /**
     * @param value This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
     * Expected value is 'SimpleSchedulePolicy'.
     */
    @JvmName("jwnjsdemkkxfimcq")
    public suspend fun schedulePolicyType(`value`: Output<String>) {
        this.schedulePolicyType = value
    }

    /**
     * @param value List of days of week this schedule has to be run.
     */
    @JvmName("ofmustiruiypjwql")
    public suspend fun scheduleRunDays(`value`: Output<List<DayOfWeek>>) {
        this.scheduleRunDays = value
    }

    @JvmName("sqhojgjascolrogq")
    public suspend fun scheduleRunDays(vararg values: Output<DayOfWeek>) {
        this.scheduleRunDays = Output.all(values.asList())
    }

    /**
     * @param values List of days of week this schedule has to be run.
     */
    @JvmName("xoognmqrtkknlsaw")
    public suspend fun scheduleRunDays(values: List<Output<DayOfWeek>>) {
        this.scheduleRunDays = Output.all(values)
    }

    /**
     * @param value Frequency of the schedule operation of this policy.
     */
    @JvmName("ybagveergwfiitpb")
    public suspend fun scheduleRunFrequency(`value`: Output<Either<String, ScheduleRunType>>) {
        this.scheduleRunFrequency = value
    }

    /**
     * @param value List of times of day this schedule has to be run.
     */
    @JvmName("ooqxqcgsxbmgbdfi")
    public suspend fun scheduleRunTimes(`value`: Output<List<String>>) {
        this.scheduleRunTimes = value
    }

    @JvmName("kccgqndqlhkxxnwv")
    public suspend fun scheduleRunTimes(vararg values: Output<String>) {
        this.scheduleRunTimes = Output.all(values.asList())
    }

    /**
     * @param values List of times of day this schedule has to be run.
     */
    @JvmName("cqibjtsxomksgbom")
    public suspend fun scheduleRunTimes(values: List<Output<String>>) {
        this.scheduleRunTimes = Output.all(values)
    }

    /**
     * @param value At every number weeks this schedule has to be run.
     */
    @JvmName("ajlnlnxibenyavtn")
    public suspend fun scheduleWeeklyFrequency(`value`: Output<Int>) {
        this.scheduleWeeklyFrequency = value
    }

    /**
     * @param value Hourly Schedule of this Policy
     */
    @JvmName("wpvpxvwqbvqesjqs")
    public suspend fun hourlySchedule(`value`: HourlyScheduleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hourlySchedule = mapped
    }

    /**
     * @param argument Hourly Schedule of this Policy
     */
    @JvmName("ygahqmlrntfmgyoy")
    public suspend fun hourlySchedule(argument: suspend HourlyScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = HourlyScheduleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.hourlySchedule = mapped
    }

    /**
     * @param value This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
     * Expected value is 'SimpleSchedulePolicy'.
     */
    @JvmName("vsqhmjussxmqajga")
    public suspend fun schedulePolicyType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schedulePolicyType = mapped
    }

    /**
     * @param value List of days of week this schedule has to be run.
     */
    @JvmName("hfjsfvnssoknwojx")
    public suspend fun scheduleRunDays(`value`: List<DayOfWeek>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleRunDays = mapped
    }

    /**
     * @param values List of days of week this schedule has to be run.
     */
    @JvmName("uuytbvtjduiakacr")
    public suspend fun scheduleRunDays(vararg values: DayOfWeek) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scheduleRunDays = mapped
    }

    /**
     * @param value Frequency of the schedule operation of this policy.
     */
    @JvmName("uktgwpdyvtotatia")
    public suspend fun scheduleRunFrequency(`value`: Either<String, ScheduleRunType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleRunFrequency = mapped
    }

    /**
     * @param value Frequency of the schedule operation of this policy.
     */
    @JvmName("fdngjlrnbyriebcw")
    public fun scheduleRunFrequency(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ScheduleRunType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scheduleRunFrequency = mapped
    }

    /**
     * @param value Frequency of the schedule operation of this policy.
     */
    @JvmName("bjwrwvyyscmcvvcu")
    public fun scheduleRunFrequency(`value`: ScheduleRunType) {
        val toBeMapped = Either.ofRight<String, ScheduleRunType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scheduleRunFrequency = mapped
    }

    /**
     * @param value List of times of day this schedule has to be run.
     */
    @JvmName("ntgoggqyooudifde")
    public suspend fun scheduleRunTimes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleRunTimes = mapped
    }

    /**
     * @param values List of times of day this schedule has to be run.
     */
    @JvmName("njiifkxpwmffdvmb")
    public suspend fun scheduleRunTimes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scheduleRunTimes = mapped
    }

    /**
     * @param value At every number weeks this schedule has to be run.
     */
    @JvmName("bqtqrivdnsrswcac")
    public suspend fun scheduleWeeklyFrequency(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleWeeklyFrequency = mapped
    }

    internal fun build(): SimpleSchedulePolicyArgs = SimpleSchedulePolicyArgs(
        hourlySchedule = hourlySchedule,
        schedulePolicyType = schedulePolicyType ?: throw PulumiNullFieldException("schedulePolicyType"),
        scheduleRunDays = scheduleRunDays,
        scheduleRunFrequency = scheduleRunFrequency,
        scheduleRunTimes = scheduleRunTimes,
        scheduleWeeklyFrequency = scheduleWeeklyFrequency,
    )
}
