@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.SoftDeleteSettingsArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.SoftDeleteState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Soft delete Settings of vault
 * @property softDeleteRetentionPeriodInDays Soft delete retention period in days
 * @property softDeleteState
 */
public data class SoftDeleteSettingsArgs(
    public val softDeleteRetentionPeriodInDays: Output<Int>? = null,
    public val softDeleteState: Output<Either<String, SoftDeleteState>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.SoftDeleteSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.SoftDeleteSettingsArgs =
        com.pulumi.azurenative.recoveryservices.inputs.SoftDeleteSettingsArgs.builder()
            .softDeleteRetentionPeriodInDays(softDeleteRetentionPeriodInDays?.applyValue({ args0 -> args0 }))
            .softDeleteState(
                softDeleteState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [SoftDeleteSettingsArgs].
 */
@PulumiTagMarker
public class SoftDeleteSettingsArgsBuilder internal constructor() {
    private var softDeleteRetentionPeriodInDays: Output<Int>? = null

    private var softDeleteState: Output<Either<String, SoftDeleteState>>? = null

    /**
     * @param value Soft delete retention period in days
     */
    @JvmName("iodjdsxipujptkuo")
    public suspend fun softDeleteRetentionPeriodInDays(`value`: Output<Int>) {
        this.softDeleteRetentionPeriodInDays = value
    }

    /**
     * @param value
     */
    @JvmName("shtabeacplrmedoy")
    public suspend fun softDeleteState(`value`: Output<Either<String, SoftDeleteState>>) {
        this.softDeleteState = value
    }

    /**
     * @param value Soft delete retention period in days
     */
    @JvmName("hnflagsdjiuytdry")
    public suspend fun softDeleteRetentionPeriodInDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.softDeleteRetentionPeriodInDays = mapped
    }

    /**
     * @param value
     */
    @JvmName("lnorlbuqcioedpqy")
    public suspend fun softDeleteState(`value`: Either<String, SoftDeleteState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.softDeleteState = mapped
    }

    /**
     * @param value
     */
    @JvmName("jehwrgotyipmnbhg")
    public fun softDeleteState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SoftDeleteState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.softDeleteState = mapped
    }

    /**
     * @param value
     */
    @JvmName("rvqirshvkldlddfr")
    public fun softDeleteState(`value`: SoftDeleteState) {
        val toBeMapped = Either.ofRight<String, SoftDeleteState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.softDeleteState = mapped
    }

    internal fun build(): SoftDeleteSettingsArgs = SoftDeleteSettingsArgs(
        softDeleteRetentionPeriodInDays = softDeleteRetentionPeriodInDays,
        softDeleteState = softDeleteState,
    )
}
