@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.VMwareCbtDiskInputArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.DiskAccountType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * VMwareCbt disk input.
 * @property diskEncryptionSetId The DiskEncryptionSet ARM Id.
 * @property diskId The disk Id.
 * @property diskType The disk type.
 * @property isOSDisk A value indicating whether the disk is the OS disk.
 * @property logStorageAccountId The log storage account ARM Id.
 * @property logStorageAccountSasSecretName The key vault secret name of the log storage account.
 */
public data class VMwareCbtDiskInputArgs(
    public val diskEncryptionSetId: Output<String>? = null,
    public val diskId: Output<String>,
    public val diskType: Output<Either<String, DiskAccountType>>? = null,
    public val isOSDisk: Output<String>,
    public val logStorageAccountId: Output<String>,
    public val logStorageAccountSasSecretName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.VMwareCbtDiskInputArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.VMwareCbtDiskInputArgs =
        com.pulumi.azurenative.recoveryservices.inputs.VMwareCbtDiskInputArgs.builder()
            .diskEncryptionSetId(diskEncryptionSetId?.applyValue({ args0 -> args0 }))
            .diskId(diskId.applyValue({ args0 -> args0 }))
            .diskType(
                diskType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .isOSDisk(isOSDisk.applyValue({ args0 -> args0 }))
            .logStorageAccountId(logStorageAccountId.applyValue({ args0 -> args0 }))
            .logStorageAccountSasSecretName(
                logStorageAccountSasSecretName.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [VMwareCbtDiskInputArgs].
 */
@PulumiTagMarker
public class VMwareCbtDiskInputArgsBuilder internal constructor() {
    private var diskEncryptionSetId: Output<String>? = null

    private var diskId: Output<String>? = null

    private var diskType: Output<Either<String, DiskAccountType>>? = null

    private var isOSDisk: Output<String>? = null

    private var logStorageAccountId: Output<String>? = null

    private var logStorageAccountSasSecretName: Output<String>? = null

    /**
     * @param value The DiskEncryptionSet ARM Id.
     */
    @JvmName("bmvqodsojgkmdvqr")
    public suspend fun diskEncryptionSetId(`value`: Output<String>) {
        this.diskEncryptionSetId = value
    }

    /**
     * @param value The disk Id.
     */
    @JvmName("alfdjqulqgbxmaxy")
    public suspend fun diskId(`value`: Output<String>) {
        this.diskId = value
    }

    /**
     * @param value The disk type.
     */
    @JvmName("heedavnjnelvjjni")
    public suspend fun diskType(`value`: Output<Either<String, DiskAccountType>>) {
        this.diskType = value
    }

    /**
     * @param value A value indicating whether the disk is the OS disk.
     */
    @JvmName("gasnhsbarewlflvh")
    public suspend fun isOSDisk(`value`: Output<String>) {
        this.isOSDisk = value
    }

    /**
     * @param value The log storage account ARM Id.
     */
    @JvmName("tdeitftteadefhoc")
    public suspend fun logStorageAccountId(`value`: Output<String>) {
        this.logStorageAccountId = value
    }

    /**
     * @param value The key vault secret name of the log storage account.
     */
    @JvmName("bsqtamymgmgdpoua")
    public suspend fun logStorageAccountSasSecretName(`value`: Output<String>) {
        this.logStorageAccountSasSecretName = value
    }

    /**
     * @param value The DiskEncryptionSet ARM Id.
     */
    @JvmName("koxcfxtuttbcbudv")
    public suspend fun diskEncryptionSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskEncryptionSetId = mapped
    }

    /**
     * @param value The disk Id.
     */
    @JvmName("xpgjdlblossrrbpr")
    public suspend fun diskId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskId = mapped
    }

    /**
     * @param value The disk type.
     */
    @JvmName("cpqvxdagfecpfvmi")
    public suspend fun diskType(`value`: Either<String, DiskAccountType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskType = mapped
    }

    /**
     * @param value The disk type.
     */
    @JvmName("mqpfwyfsjeebetjf")
    public fun diskType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DiskAccountType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskType = mapped
    }

    /**
     * @param value The disk type.
     */
    @JvmName("uwdcefbrsqedjwdo")
    public fun diskType(`value`: DiskAccountType) {
        val toBeMapped = Either.ofRight<String, DiskAccountType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskType = mapped
    }

    /**
     * @param value A value indicating whether the disk is the OS disk.
     */
    @JvmName("jqusovnnvwjyydwm")
    public suspend fun isOSDisk(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isOSDisk = mapped
    }

    /**
     * @param value The log storage account ARM Id.
     */
    @JvmName("bhsfptqgohimyewj")
    public suspend fun logStorageAccountId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logStorageAccountId = mapped
    }

    /**
     * @param value The key vault secret name of the log storage account.
     */
    @JvmName("voxaitelpgoyggyr")
    public suspend fun logStorageAccountSasSecretName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logStorageAccountSasSecretName = mapped
    }

    internal fun build(): VMwareCbtDiskInputArgs = VMwareCbtDiskInputArgs(
        diskEncryptionSetId = diskEncryptionSetId,
        diskId = diskId ?: throw PulumiNullFieldException("diskId"),
        diskType = diskType,
        isOSDisk = isOSDisk ?: throw PulumiNullFieldException("isOSDisk"),
        logStorageAccountId = logStorageAccountId ?: throw PulumiNullFieldException("logStorageAccountId"),
        logStorageAccountSasSecretName = logStorageAccountSasSecretName ?: throw
            PulumiNullFieldException("logStorageAccountSasSecretName"),
    )
}
