@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.WeeklyScheduleArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.DayOfWeek
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property scheduleRunDays
 * @property scheduleRunTimes List of times of day this schedule has to be run.
 */
public data class WeeklyScheduleArgs(
    public val scheduleRunDays: Output<List<DayOfWeek>>? = null,
    public val scheduleRunTimes: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.WeeklyScheduleArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.WeeklyScheduleArgs =
        com.pulumi.azurenative.recoveryservices.inputs.WeeklyScheduleArgs.builder()
            .scheduleRunDays(
                scheduleRunDays?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .scheduleRunTimes(scheduleRunTimes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [WeeklyScheduleArgs].
 */
@PulumiTagMarker
public class WeeklyScheduleArgsBuilder internal constructor() {
    private var scheduleRunDays: Output<List<DayOfWeek>>? = null

    private var scheduleRunTimes: Output<List<String>>? = null

    /**
     * @param value
     */
    @JvmName("ubbydngutlkpdise")
    public suspend fun scheduleRunDays(`value`: Output<List<DayOfWeek>>) {
        this.scheduleRunDays = value
    }

    @JvmName("lfqmkljbmpibreah")
    public suspend fun scheduleRunDays(vararg values: Output<DayOfWeek>) {
        this.scheduleRunDays = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("boyuwpnjglhwlbcf")
    public suspend fun scheduleRunDays(values: List<Output<DayOfWeek>>) {
        this.scheduleRunDays = Output.all(values)
    }

    /**
     * @param value List of times of day this schedule has to be run.
     */
    @JvmName("wqgoinwpttclkiaa")
    public suspend fun scheduleRunTimes(`value`: Output<List<String>>) {
        this.scheduleRunTimes = value
    }

    @JvmName("ebbelfrvfdtdxsss")
    public suspend fun scheduleRunTimes(vararg values: Output<String>) {
        this.scheduleRunTimes = Output.all(values.asList())
    }

    /**
     * @param values List of times of day this schedule has to be run.
     */
    @JvmName("fheleyslthlyximy")
    public suspend fun scheduleRunTimes(values: List<Output<String>>) {
        this.scheduleRunTimes = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("dfuscdfpnuqbmsmb")
    public suspend fun scheduleRunDays(`value`: List<DayOfWeek>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleRunDays = mapped
    }

    /**
     * @param values
     */
    @JvmName("ldokdmfyubeyypsk")
    public suspend fun scheduleRunDays(vararg values: DayOfWeek) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scheduleRunDays = mapped
    }

    /**
     * @param value List of times of day this schedule has to be run.
     */
    @JvmName("nuvayqbucfnhhtht")
    public suspend fun scheduleRunTimes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleRunTimes = mapped
    }

    /**
     * @param values List of times of day this schedule has to be run.
     */
    @JvmName("hlrxfqchnpufbuat")
    public suspend fun scheduleRunTimes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scheduleRunTimes = mapped
    }

    internal fun build(): WeeklyScheduleArgs = WeeklyScheduleArgs(
        scheduleRunDays = scheduleRunDays,
        scheduleRunTimes = scheduleRunTimes,
    )
}
