@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Azure Storage Account workload-specific container.
 * @property acquireStorageAccountLock Whether storage account lock is to be acquired for this container or not.
 * @property backupManagementType Type of backup management for the container.
 * @property containerType Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
 * Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
 * Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
 * Backup is VMAppContainer
 * Expected value is 'StorageContainer'.
 * @property friendlyName Friendly name of the container.
 * @property healthStatus Status of health of the container.
 * @property protectableObjectType Type of the protectable object associated with this container
 * @property protectedItemCount Number of items backed up in this container.
 * @property registrationStatus Status of registration of the container with the Recovery Services Vault.
 * @property resourceGroup Resource group name of Recovery Services Vault.
 * @property sourceResourceId Fully qualified ARM url.
 * @property storageAccountVersion Storage account version.
 */
public data class AzureStorageContainerResponse(
    public val acquireStorageAccountLock: String? = null,
    public val backupManagementType: String? = null,
    public val containerType: String,
    public val friendlyName: String? = null,
    public val healthStatus: String? = null,
    public val protectableObjectType: String? = null,
    public val protectedItemCount: Double? = null,
    public val registrationStatus: String? = null,
    public val resourceGroup: String? = null,
    public val sourceResourceId: String? = null,
    public val storageAccountVersion: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.AzureStorageContainerResponse):
            AzureStorageContainerResponse = AzureStorageContainerResponse(
            acquireStorageAccountLock = javaType.acquireStorageAccountLock().map({ args0 ->
                args0
            }).orElse(null),
            backupManagementType = javaType.backupManagementType().map({ args0 -> args0 }).orElse(null),
            containerType = javaType.containerType(),
            friendlyName = javaType.friendlyName().map({ args0 -> args0 }).orElse(null),
            healthStatus = javaType.healthStatus().map({ args0 -> args0 }).orElse(null),
            protectableObjectType = javaType.protectableObjectType().map({ args0 -> args0 }).orElse(null),
            protectedItemCount = javaType.protectedItemCount().map({ args0 -> args0 }).orElse(null),
            registrationStatus = javaType.registrationStatus().map({ args0 -> args0 }).orElse(null),
            resourceGroup = javaType.resourceGroup().map({ args0 -> args0 }).orElse(null),
            sourceResourceId = javaType.sourceResourceId().map({ args0 -> args0 }).orElse(null),
            storageAccountVersion = javaType.storageAccountVersion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
