@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Container identity information
 * @property aadTenantId Protection container identity - AAD Tenant
 * @property audience Protection container identity - Audience
 * @property servicePrincipalClientId Protection container identity - AAD Service Principal
 * @property uniqueName Unique name of the container
 */
public data class ContainerIdentityInfoResponse(
    public val aadTenantId: String? = null,
    public val audience: String? = null,
    public val servicePrincipalClientId: String? = null,
    public val uniqueName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.ContainerIdentityInfoResponse):
            ContainerIdentityInfoResponse = ContainerIdentityInfoResponse(
            aadTenantId = javaType.aadTenantId().map({ args0 -> args0 }).orElse(null),
            audience = javaType.audience().map({ args0 -> args0 }).orElse(null),
            servicePrincipalClientId = javaType.servicePrincipalClientId().map({ args0 -> args0 }).orElse(null),
            uniqueName = javaType.uniqueName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
