@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Base class for generic container of backup items
 * @property backupManagementType Type of backup management for the container.
 * @property containerType Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
 * Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
 * Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
 * Backup is VMAppContainer
 * Expected value is 'GenericContainer'.
 * @property extendedInformation Extended information (not returned in List container API calls)
 * @property fabricName Name of the container's fabric
 * @property friendlyName Friendly name of the container.
 * @property healthStatus Status of health of the container.
 * @property protectableObjectType Type of the protectable object associated with this container
 * @property registrationStatus Status of registration of the container with the Recovery Services Vault.
 */
public data class GenericContainerResponse(
    public val backupManagementType: String? = null,
    public val containerType: String,
    public val extendedInformation: GenericContainerExtendedInfoResponse? = null,
    public val fabricName: String? = null,
    public val friendlyName: String? = null,
    public val healthStatus: String? = null,
    public val protectableObjectType: String? = null,
    public val registrationStatus: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.GenericContainerResponse):
            GenericContainerResponse = GenericContainerResponse(
            backupManagementType = javaType.backupManagementType().map({ args0 -> args0 }).orElse(null),
            containerType = javaType.containerType(),
            extendedInformation = javaType.extendedInformation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.GenericContainerExtendedInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            fabricName = javaType.fabricName().map({ args0 -> args0 }).orElse(null),
            friendlyName = javaType.friendlyName().map({ args0 -> args0 }).orElse(null),
            healthStatus = javaType.healthStatus().map({ args0 -> args0 }).orElse(null),
            protectableObjectType = javaType.protectableObjectType().map({ args0 -> args0 }).orElse(null),
            registrationStatus = javaType.registrationStatus().map({ args0 -> args0 }).orElse(null),
        )
    }
}
