@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Hyper-V host details.
 * @property id The Hyper-V host Id.
 * @property marsAgentVersion The Mars agent version.
 * @property name The Hyper-V host name.
 */
public data class HyperVHostDetailsResponse(
    public val id: String,
    public val marsAgentVersion: String,
    public val name: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.HyperVHostDetailsResponse):
            HyperVHostDetailsResponse = HyperVHostDetailsResponse(
            id = javaType.id(),
            marsAgentVersion = javaType.marsAgentVersion(),
            name = javaType.name(),
        )
    }
}
