@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * InMageRcm provider specific container mapping details.
 * @property enableAgentAutoUpgrade A value indicating whether the flag for enable agent auto upgrade.
 * @property instanceType Gets the class type. Overridden in derived classes.
 * Expected value is 'InMageRcm'.
 */
public data class InMageRcmProtectionContainerMappingDetailsResponse(
    public val enableAgentAutoUpgrade: String,
    public val instanceType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.InMageRcmProtectionContainerMappingDetailsResponse):
            InMageRcmProtectionContainerMappingDetailsResponse =
            InMageRcmProtectionContainerMappingDetailsResponse(
                enableAgentAutoUpgrade = javaType.enableAgentAutoUpgrade(),
                instanceType = javaType.instanceType(),
            )
    }
}
