@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Push installer details.
 * @property biosId The push installer Bios Id.
 * @property fabricObjectId The fabric object Id.
 * @property fqdn The push installer Fqdn.
 * @property health The health of the push installer.
 * @property healthErrors The health errors.
 * @property id The push installer Id.
 * @property lastHeartbeatUtc The last heartbeat received from the push installer.
 * @property name The push installer name.
 * @property version The version.
 */
public data class PushInstallerDetailsResponse(
    public val biosId: String,
    public val fabricObjectId: String,
    public val fqdn: String,
    public val health: String,
    public val healthErrors: List<HealthErrorResponse>,
    public val id: String,
    public val lastHeartbeatUtc: String,
    public val name: String,
    public val version: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.PushInstallerDetailsResponse):
            PushInstallerDetailsResponse = PushInstallerDetailsResponse(
            biosId = javaType.biosId(),
            fabricObjectId = javaType.fabricObjectId(),
            fqdn = javaType.fqdn(),
            health = javaType.health(),
            healthErrors = javaType.healthErrors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.HealthErrorResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            lastHeartbeatUtc = javaType.lastHeartbeatUtc(),
            name = javaType.name(),
            version = javaType.version(),
        )
    }
}
