@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Recovery plan A2A specific details.
 * @property instanceType Gets the Instance type.
 * Expected value is 'A2A'.
 * @property primaryExtendedLocation The primary extended location.
 * @property primaryZone The primary zone.
 * @property recoveryExtendedLocation The recovery extended location.
 * @property recoveryZone The recovery zone.
 */
public data class RecoveryPlanA2ADetailsResponse(
    public val instanceType: String,
    public val primaryExtendedLocation: ExtendedLocationResponse? = null,
    public val primaryZone: String? = null,
    public val recoveryExtendedLocation: ExtendedLocationResponse? = null,
    public val recoveryZone: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.RecoveryPlanA2ADetailsResponse):
            RecoveryPlanA2ADetailsResponse = RecoveryPlanA2ADetailsResponse(
            instanceType = javaType.instanceType(),
            primaryExtendedLocation = javaType.primaryExtendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            primaryZone = javaType.primaryZone().map({ args0 -> args0 }).orElse(null),
            recoveryExtendedLocation = javaType.recoveryExtendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            recoveryZone = javaType.recoveryZone().map({ args0 -> args0 }).orElse(null),
        )
    }
}
