@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Recovery services provider properties.
 * @property allowedScenarios The scenarios allowed on this provider.
 * @property authenticationIdentityDetails The authentication identity details.
 * @property biosId The Bios Id.
 * @property connectionStatus A value indicating whether DRA is responsive.
 * @property dataPlaneAuthenticationIdentityDetails The data plane authentication identity details.
 * @property draIdentifier The DRA Id.
 * @property fabricFriendlyName The fabric friendly name.
 * @property fabricType Type of the site.
 * @property friendlyName Friendly name of the DRA.
 * @property healthErrorDetails The recovery services provider health error details.
 * @property lastHeartBeat Time when last heartbeat was sent by the DRA.
 * @property machineId The machine Id.
 * @property machineName The machine name.
 * @property protectedItemCount Number of protected VMs currently managed by the DRA.
 * @property providerVersion The provider version.
 * @property providerVersionDetails The provider version details.
 * @property providerVersionExpiryDate Expiry date of the version.
 * @property providerVersionState DRA version status.
 * @property resourceAccessIdentityDetails The resource access identity details.
 * @property serverVersion The fabric provider.
 */
public data class RecoveryServicesProviderPropertiesResponse(
    public val allowedScenarios: List<String>? = null,
    public val authenticationIdentityDetails: IdentityProviderDetailsResponse? = null,
    public val biosId: String? = null,
    public val connectionStatus: String? = null,
    public val dataPlaneAuthenticationIdentityDetails: IdentityProviderDetailsResponse? = null,
    public val draIdentifier: String? = null,
    public val fabricFriendlyName: String? = null,
    public val fabricType: String? = null,
    public val friendlyName: String? = null,
    public val healthErrorDetails: List<HealthErrorResponse>? = null,
    public val lastHeartBeat: String? = null,
    public val machineId: String? = null,
    public val machineName: String? = null,
    public val protectedItemCount: Int? = null,
    public val providerVersion: String? = null,
    public val providerVersionDetails: VersionDetailsResponse? = null,
    public val providerVersionExpiryDate: String? = null,
    public val providerVersionState: String? = null,
    public val resourceAccessIdentityDetails: IdentityProviderDetailsResponse? = null,
    public val serverVersion: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.RecoveryServicesProviderPropertiesResponse):
            RecoveryServicesProviderPropertiesResponse = RecoveryServicesProviderPropertiesResponse(
            allowedScenarios = javaType.allowedScenarios().map({ args0 -> args0 }),
            authenticationIdentityDetails = javaType.authenticationIdentityDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.IdentityProviderDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            biosId = javaType.biosId().map({ args0 -> args0 }).orElse(null),
            connectionStatus = javaType.connectionStatus().map({ args0 -> args0 }).orElse(null),
            dataPlaneAuthenticationIdentityDetails = javaType.dataPlaneAuthenticationIdentityDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.IdentityProviderDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            draIdentifier = javaType.draIdentifier().map({ args0 -> args0 }).orElse(null),
            fabricFriendlyName = javaType.fabricFriendlyName().map({ args0 -> args0 }).orElse(null),
            fabricType = javaType.fabricType().map({ args0 -> args0 }).orElse(null),
            friendlyName = javaType.friendlyName().map({ args0 -> args0 }).orElse(null),
            healthErrorDetails = javaType.healthErrorDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.HealthErrorResponse.Companion.toKotlin(args0)
                })
            }),
            lastHeartBeat = javaType.lastHeartBeat().map({ args0 -> args0 }).orElse(null),
            machineId = javaType.machineId().map({ args0 -> args0 }).orElse(null),
            machineName = javaType.machineName().map({ args0 -> args0 }).orElse(null),
            protectedItemCount = javaType.protectedItemCount().map({ args0 -> args0 }).orElse(null),
            providerVersion = javaType.providerVersion().map({ args0 -> args0 }).orElse(null),
            providerVersionDetails = javaType.providerVersionDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.VersionDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            providerVersionExpiryDate = javaType.providerVersionExpiryDate().map({ args0 ->
                args0
            }).orElse(null),
            providerVersionState = javaType.providerVersionState().map({ args0 -> args0 }).orElse(null),
            resourceAccessIdentityDetails = javaType.resourceAccessIdentityDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.IdentityProviderDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            serverVersion = javaType.serverVersion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
