@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Reprotect agent details.
 * @property accessibleDatastores The list of accessible datastores fetched from discovery.
 * @property biosId The reprotect agent Bios Id.
 * @property fabricObjectId The fabric object Id.
 * @property fqdn The reprotect agent Fqdn.
 * @property health The health of the reprotect agent.
 * @property healthErrors The health errors.
 * @property id The reprotect agent Id.
 * @property lastDiscoveryInUtc The last time when SDS information discovered in SRS.
 * @property lastHeartbeatUtc The last heartbeat received from the reprotect agent.
 * @property name The reprotect agent name.
 * @property protectedItemCount The protected item count.
 * @property vcenterId The Vcenter Id.
 * @property version The version.
 */
public data class ReprotectAgentDetailsResponse(
    public val accessibleDatastores: List<String>,
    public val biosId: String,
    public val fabricObjectId: String,
    public val fqdn: String,
    public val health: String,
    public val healthErrors: List<HealthErrorResponse>,
    public val id: String,
    public val lastDiscoveryInUtc: String,
    public val lastHeartbeatUtc: String,
    public val name: String,
    public val protectedItemCount: Int,
    public val vcenterId: String,
    public val version: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.ReprotectAgentDetailsResponse):
            ReprotectAgentDetailsResponse = ReprotectAgentDetailsResponse(
            accessibleDatastores = javaType.accessibleDatastores().map({ args0 -> args0 }),
            biosId = javaType.biosId(),
            fabricObjectId = javaType.fabricObjectId(),
            fqdn = javaType.fqdn(),
            health = javaType.health(),
            healthErrors = javaType.healthErrors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.HealthErrorResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            lastDiscoveryInUtc = javaType.lastDiscoveryInUtc(),
            lastHeartbeatUtc = javaType.lastHeartbeatUtc(),
            name = javaType.name(),
            protectedItemCount = javaType.protectedItemCount(),
            vcenterId = javaType.vcenterId(),
            version = javaType.version(),
        )
    }
}
