@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Hyper V VM network details.
 * @property enableAcceleratedNetworkingOnRecovery A value indicating whether the NIC has accelerated networking enabled.
 * @property enableAcceleratedNetworkingOnTfo Whether the TFO NIC has accelerated networking enabled.
 * @property ipConfigs The IP configurations of the NIC.
 * @property nicId The nic Id.
 * @property recoveryNetworkSecurityGroupId The id of the NSG associated with the NIC.
 * @property recoveryNicName The name of the NIC to be used when creating target NICs.
 * @property recoveryNicResourceGroupName The resource group of the NIC to be used when creating target NICs.
 * @property recoveryVMNetworkId Recovery VM network Id.
 * @property replicaNicId The replica nic Id.
 * @property reuseExistingNic A value indicating whether an existing NIC is allowed to be reused during failover subject to availability.
 * @property selectionType Selection type for failover.
 * @property sourceNicArmId The source nic ARM Id.
 * @property targetNicName Target NIC name.
 * @property tfoNetworkSecurityGroupId The NSG to be used by NIC during test failover.
 * @property tfoRecoveryNicName The name of the NIC to be used when creating target NICs in TFO.
 * @property tfoRecoveryNicResourceGroupName The resource group of the NIC to be used when creating target NICs in TFO.
 * @property tfoReuseExistingNic A value indicating whether an existing NIC is allowed to be reused during test failover subject to availability.
 * @property tfoVMNetworkId The network to be used by NIC during test failover.
 * @property vMNetworkName VM network name.
 */
public data class VMNicDetailsResponse(
    public val enableAcceleratedNetworkingOnRecovery: Boolean? = null,
    public val enableAcceleratedNetworkingOnTfo: Boolean? = null,
    public val ipConfigs: List<IPConfigDetailsResponse>? = null,
    public val nicId: String? = null,
    public val recoveryNetworkSecurityGroupId: String? = null,
    public val recoveryNicName: String? = null,
    public val recoveryNicResourceGroupName: String? = null,
    public val recoveryVMNetworkId: String? = null,
    public val replicaNicId: String? = null,
    public val reuseExistingNic: Boolean? = null,
    public val selectionType: String? = null,
    public val sourceNicArmId: String? = null,
    public val targetNicName: String? = null,
    public val tfoNetworkSecurityGroupId: String? = null,
    public val tfoRecoveryNicName: String? = null,
    public val tfoRecoveryNicResourceGroupName: String? = null,
    public val tfoReuseExistingNic: Boolean? = null,
    public val tfoVMNetworkId: String? = null,
    public val vMNetworkName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.VMNicDetailsResponse):
            VMNicDetailsResponse = VMNicDetailsResponse(
            enableAcceleratedNetworkingOnRecovery = javaType.enableAcceleratedNetworkingOnRecovery().map({ args0 ->
                args0
            }).orElse(null),
            enableAcceleratedNetworkingOnTfo = javaType.enableAcceleratedNetworkingOnTfo().map({ args0 ->
                args0
            }).orElse(null),
            ipConfigs = javaType.ipConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.IPConfigDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            nicId = javaType.nicId().map({ args0 -> args0 }).orElse(null),
            recoveryNetworkSecurityGroupId = javaType.recoveryNetworkSecurityGroupId().map({ args0 ->
                args0
            }).orElse(null),
            recoveryNicName = javaType.recoveryNicName().map({ args0 -> args0 }).orElse(null),
            recoveryNicResourceGroupName = javaType.recoveryNicResourceGroupName().map({ args0 ->
                args0
            }).orElse(null),
            recoveryVMNetworkId = javaType.recoveryVMNetworkId().map({ args0 -> args0 }).orElse(null),
            replicaNicId = javaType.replicaNicId().map({ args0 -> args0 }).orElse(null),
            reuseExistingNic = javaType.reuseExistingNic().map({ args0 -> args0 }).orElse(null),
            selectionType = javaType.selectionType().map({ args0 -> args0 }).orElse(null),
            sourceNicArmId = javaType.sourceNicArmId().map({ args0 -> args0 }).orElse(null),
            targetNicName = javaType.targetNicName().map({ args0 -> args0 }).orElse(null),
            tfoNetworkSecurityGroupId = javaType.tfoNetworkSecurityGroupId().map({ args0 ->
                args0
            }).orElse(null),
            tfoRecoveryNicName = javaType.tfoRecoveryNicName().map({ args0 -> args0 }).orElse(null),
            tfoRecoveryNicResourceGroupName = javaType.tfoRecoveryNicResourceGroupName().map({ args0 ->
                args0
            }).orElse(null),
            tfoReuseExistingNic = javaType.tfoReuseExistingNic().map({ args0 -> args0 }).orElse(null),
            tfoVMNetworkId = javaType.tfoVMNetworkId().map({ args0 -> args0 }).orElse(null),
            vMNetworkName = javaType.vMNetworkName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
