@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The redundancy Settings of a Vault
 * @property crossRegionRestore Flag to show if Cross Region Restore is enabled on the Vault or not
 * @property standardTierStorageRedundancy The storage redundancy setting of a vault
 */
public data class VaultPropertiesResponseRedundancySettings(
    public val crossRegionRestore: String,
    public val standardTierStorageRedundancy: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.VaultPropertiesResponseRedundancySettings):
            VaultPropertiesResponseRedundancySettings = VaultPropertiesResponseRedundancySettings(
            crossRegionRestore = javaType.crossRegionRestore(),
            standardTierStorageRedundancy = javaType.standardTierStorageRedundancy(),
        )
    }
}
