@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * VMware Cbt specific policy details.
 * @property appConsistentFrequencyInMinutes The app consistent snapshot frequency in minutes.
 * @property crashConsistentFrequencyInMinutes The crash consistent snapshot frequency in minutes.
 * @property instanceType Gets the class type. Overridden in derived classes.
 * Expected value is 'VMwareCbt'.
 * @property recoveryPointHistoryInMinutes The duration in minutes until which the recovery points need to be stored.
 */
public data class VmwareCbtPolicyDetailsResponse(
    public val appConsistentFrequencyInMinutes: Int? = null,
    public val crashConsistentFrequencyInMinutes: Int? = null,
    public val instanceType: String,
    public val recoveryPointHistoryInMinutes: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.VmwareCbtPolicyDetailsResponse):
            VmwareCbtPolicyDetailsResponse = VmwareCbtPolicyDetailsResponse(
            appConsistentFrequencyInMinutes = javaType.appConsistentFrequencyInMinutes().map({ args0 ->
                args0
            }).orElse(null),
            crashConsistentFrequencyInMinutes = javaType.crashConsistentFrequencyInMinutes().map({ args0 ->
                args0
            }).orElse(null),
            instanceType = javaType.instanceType(),
            recoveryPointHistoryInMinutes = javaType.recoveryPointHistoryInMinutes().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
