@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.redhatopenshift.kotlin

import com.pulumi.azurenative.redhatopenshift.OpenShiftClusterArgs.builder
import com.pulumi.azurenative.redhatopenshift.kotlin.inputs.APIServerProfileArgs
import com.pulumi.azurenative.redhatopenshift.kotlin.inputs.APIServerProfileArgsBuilder
import com.pulumi.azurenative.redhatopenshift.kotlin.inputs.ClusterProfileArgs
import com.pulumi.azurenative.redhatopenshift.kotlin.inputs.ClusterProfileArgsBuilder
import com.pulumi.azurenative.redhatopenshift.kotlin.inputs.ConsoleProfileArgs
import com.pulumi.azurenative.redhatopenshift.kotlin.inputs.ConsoleProfileArgsBuilder
import com.pulumi.azurenative.redhatopenshift.kotlin.inputs.IngressProfileArgs
import com.pulumi.azurenative.redhatopenshift.kotlin.inputs.IngressProfileArgsBuilder
import com.pulumi.azurenative.redhatopenshift.kotlin.inputs.MasterProfileArgs
import com.pulumi.azurenative.redhatopenshift.kotlin.inputs.MasterProfileArgsBuilder
import com.pulumi.azurenative.redhatopenshift.kotlin.inputs.NetworkProfileArgs
import com.pulumi.azurenative.redhatopenshift.kotlin.inputs.NetworkProfileArgsBuilder
import com.pulumi.azurenative.redhatopenshift.kotlin.inputs.ServicePrincipalProfileArgs
import com.pulumi.azurenative.redhatopenshift.kotlin.inputs.ServicePrincipalProfileArgsBuilder
import com.pulumi.azurenative.redhatopenshift.kotlin.inputs.WorkerProfileArgs
import com.pulumi.azurenative.redhatopenshift.kotlin.inputs.WorkerProfileArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * OpenShiftCluster represents an Azure Red Hat OpenShift cluster.
 * Azure REST API version: 2022-09-04. Prior API version in Azure Native 1.x: 2020-04-30.
 * Other available API versions: 2023-04-01, 2023-07-01-preview, 2023-09-04.
 * ## Example Usage
 * ### Creates or updates a OpenShift cluster with the specified subscription, resource group and resource name.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var openShiftCluster = new AzureNative.RedHatOpenShift.OpenShiftCluster("openShiftCluster", new()
 *     {
 *         ApiserverProfile = new AzureNative.RedHatOpenShift.Inputs.APIServerProfileArgs
 *         {
 *             Visibility = "Public",
 *         },
 *         ClusterProfile = new AzureNative.RedHatOpenShift.Inputs.ClusterProfileArgs
 *         {
 *             Domain = "cluster.location.aroapp.io",
 *             FipsValidatedModules = "Enabled",
 *             PullSecret = "{\"auths\":{\"registry.connect.redhat.com\":{\"auth\":\"\"},\"registry.redhat.io\":{\"auth\":\"\"}}}",
 *             ResourceGroupId = "/subscriptions/subscriptionId/resourceGroups/clusterResourceGroup",
 *         },
 *         ConsoleProfile = null,
 *         IngressProfiles = new[]
 *         {
 *             new AzureNative.RedHatOpenShift.Inputs.IngressProfileArgs
 *             {
 *                 Name = "default",
 *                 Visibility = "Public",
 *             },
 *         },
 *         Location = "location",
 *         MasterProfile = new AzureNative.RedHatOpenShift.Inputs.MasterProfileArgs
 *         {
 *             EncryptionAtHost = "Enabled",
 *             SubnetId = "/subscriptions/subscriptionId/resourceGroups/vnetResourceGroup/providers/Microsoft.Network/virtualNetworks/vnet/subnets/master",
 *             VmSize = "Standard_D8s_v3",
 *         },
 *         NetworkProfile = new AzureNative.RedHatOpenShift.Inputs.NetworkProfileArgs
 *         {
 *             PodCidr = "10.128.0.0/14",
 *             ServiceCidr = "172.30.0.0/16",
 *         },
 *         ResourceGroupName = "resourceGroup",
 *         ResourceName = "resourceName",
 *         ServicePrincipalProfile = new AzureNative.RedHatOpenShift.Inputs.ServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientId",
 *             ClientSecret = "clientSecret",
 *         },
 *         Tags =
 *         {
 *             { "key", "value" },
 *         },
 *         WorkerProfiles = new[]
 *         {
 *             new AzureNative.RedHatOpenShift.Inputs.WorkerProfileArgs
 *             {
 *                 Count = 3,
 *                 DiskSizeGB = 128,
 *                 Name = "worker",
 *                 SubnetId = "/subscriptions/subscriptionId/resourceGroups/vnetResourceGroup/providers/Microsoft.Network/virtualNetworks/vnet/subnets/worker",
 *                 VmSize = "Standard_D2s_v3",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/redhatopenshift/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := redhatopenshift.NewOpenShiftCluster(ctx, "openShiftCluster", &redhatopenshift.OpenShiftClusterArgs{
 * 			ApiserverProfile: &redhatopenshift.APIServerProfileArgs{
 * 				Visibility: pulumi.String("Public"),
 * 			},
 * 			ClusterProfile: &redhatopenshift.ClusterProfileArgs{
 * 				Domain:               pulumi.String("cluster.location.aroapp.io"),
 * 				FipsValidatedModules: pulumi.String("Enabled"),
 * 				PullSecret:           pulumi.String("{\"auths\":{\"registry.connect.redhat.com\":{\"auth\":\"\"},\"registry.redhat.io\":{\"auth\":\"\"}}}"),
 * 				ResourceGroupId:      pulumi.String("/subscriptions/subscriptionId/resourceGroups/clusterResourceGroup"),
 * 			},
 * 			ConsoleProfile: nil,
 * 			IngressProfiles: []redhatopenshift.IngressProfileArgs{
 * 				{
 * 					Name:       pulumi.String("default"),
 * 					Visibility: pulumi.String("Public"),
 * 				},
 * 			},
 * 			Location: pulumi.String("location"),
 * 			MasterProfile: &redhatopenshift.MasterProfileArgs{
 * 				EncryptionAtHost: pulumi.String("Enabled"),
 * 				SubnetId:         pulumi.String("/subscriptions/subscriptionId/resourceGroups/vnetResourceGroup/providers/Microsoft.Network/virtualNetworks/vnet/subnets/master"),
 * 				VmSize:           pulumi.String("Standard_D8s_v3"),
 * 			},
 * 			NetworkProfile: &redhatopenshift.NetworkProfileArgs{
 * 				PodCidr:     pulumi.String("10.128.0.0/14"),
 * 				ServiceCidr: pulumi.String("172.30.0.0/16"),
 * 			},
 * 			ResourceGroupName: pulumi.String("resourceGroup"),
 * 			ResourceName:      pulumi.String("resourceName"),
 * 			ServicePrincipalProfile: &redhatopenshift.ServicePrincipalProfileArgs{
 * 				ClientId:     pulumi.String("clientId"),
 * 				ClientSecret: pulumi.String("clientSecret"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key": pulumi.String("value"),
 * 			},
 * 			WorkerProfiles: []redhatopenshift.WorkerProfileArgs{
 * 				{
 * 					Count:      pulumi.Int(3),
 * 					DiskSizeGB: pulumi.Int(128),
 * 					Name:       pulumi.String("worker"),
 * 					SubnetId:   pulumi.String("/subscriptions/subscriptionId/resourceGroups/vnetResourceGroup/providers/Microsoft.Network/virtualNetworks/vnet/subnets/worker"),
 * 					VmSize:     pulumi.String("Standard_D2s_v3"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.redhatopenshift.OpenShiftCluster;
 * import com.pulumi.azurenative.redhatopenshift.OpenShiftClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var openShiftCluster = new OpenShiftCluster("openShiftCluster", OpenShiftClusterArgs.builder()
 *             .apiserverProfile(Map.of("visibility", "Public"))
 *             .clusterProfile(Map.ofEntries(
 *                 Map.entry("domain", "cluster.location.aroapp.io"),
 *                 Map.entry("fipsValidatedModules", "Enabled"),
 *                 Map.entry("pullSecret", "{\"auths\":{\"registry.connect.redhat.com\":{\"auth\":\"\"},\"registry.redhat.io\":{\"auth\":\"\"}}}"),
 *                 Map.entry("resourceGroupId", "/subscriptions/subscriptionId/resourceGroups/clusterResourceGroup")
 *             ))
 *             .consoleProfile()
 *             .ingressProfiles(Map.ofEntries(
 *                 Map.entry("name", "default"),
 *                 Map.entry("visibility", "Public")
 *             ))
 *             .location("location")
 *             .masterProfile(Map.ofEntries(
 *                 Map.entry("encryptionAtHost", "Enabled"),
 *                 Map.entry("subnetId", "/subscriptions/subscriptionId/resourceGroups/vnetResourceGroup/providers/Microsoft.Network/virtualNetworks/vnet/subnets/master"),
 *                 Map.entry("vmSize", "Standard_D8s_v3")
 *             ))
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("podCidr", "10.128.0.0/14"),
 *                 Map.entry("serviceCidr", "172.30.0.0/16")
 *             ))
 *             .resourceGroupName("resourceGroup")
 *             .resourceName("resourceName")
 *             .servicePrincipalProfile(Map.ofEntries(
 *                 Map.entry("clientId", "clientId"),
 *                 Map.entry("clientSecret", "clientSecret")
 *             ))
 *             .tags(Map.of("key", "value"))
 *             .workerProfiles(Map.ofEntries(
 *                 Map.entry("count", 3),
 *                 Map.entry("diskSizeGB", 128),
 *                 Map.entry("name", "worker"),
 *                 Map.entry("subnetId", "/subscriptions/subscriptionId/resourceGroups/vnetResourceGroup/providers/Microsoft.Network/virtualNetworks/vnet/subnets/worker"),
 *                 Map.entry("vmSize", "Standard_D2s_v3")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:redhatopenshift:OpenShiftCluster resourceName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RedHatOpenShift/openShiftClusters/{resourceName}
 * ```
 * @property apiserverProfile The cluster API server profile.
 * @property clusterProfile The cluster profile.
 * @property consoleProfile The console profile.
 * @property ingressProfiles The cluster ingress profiles.
 * @property location The geo-location where the resource lives
 * @property masterProfile The cluster master profile.
 * @property networkProfile The cluster network profile.
 * @property provisioningState The cluster provisioning state.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The name of the OpenShift cluster resource.
 * @property servicePrincipalProfile The cluster service principal profile.
 * @property tags Resource tags.
 * @property workerProfiles The cluster worker profiles.
 */
public data class OpenShiftClusterArgs(
    public val apiserverProfile: Output<APIServerProfileArgs>? = null,
    public val clusterProfile: Output<ClusterProfileArgs>? = null,
    public val consoleProfile: Output<ConsoleProfileArgs>? = null,
    public val ingressProfiles: Output<List<IngressProfileArgs>>? = null,
    public val location: Output<String>? = null,
    public val masterProfile: Output<MasterProfileArgs>? = null,
    public val networkProfile: Output<NetworkProfileArgs>? = null,
    public val provisioningState: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val servicePrincipalProfile: Output<ServicePrincipalProfileArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val workerProfiles: Output<List<WorkerProfileArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.redhatopenshift.OpenShiftClusterArgs> {
    override fun toJava(): com.pulumi.azurenative.redhatopenshift.OpenShiftClusterArgs =
        com.pulumi.azurenative.redhatopenshift.OpenShiftClusterArgs.builder()
            .apiserverProfile(apiserverProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .clusterProfile(clusterProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .consoleProfile(consoleProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ingressProfiles(
                ingressProfiles?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .masterProfile(masterProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .networkProfile(networkProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .provisioningState(provisioningState?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .servicePrincipalProfile(
                servicePrincipalProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workerProfiles(
                workerProfiles?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [OpenShiftClusterArgs].
 */
@PulumiTagMarker
public class OpenShiftClusterArgsBuilder internal constructor() {
    private var apiserverProfile: Output<APIServerProfileArgs>? = null

    private var clusterProfile: Output<ClusterProfileArgs>? = null

    private var consoleProfile: Output<ConsoleProfileArgs>? = null

    private var ingressProfiles: Output<List<IngressProfileArgs>>? = null

    private var location: Output<String>? = null

    private var masterProfile: Output<MasterProfileArgs>? = null

    private var networkProfile: Output<NetworkProfileArgs>? = null

    private var provisioningState: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var servicePrincipalProfile: Output<ServicePrincipalProfileArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var workerProfiles: Output<List<WorkerProfileArgs>>? = null

    /**
     * @param value The cluster API server profile.
     */
    @JvmName("jridgjnpnakhpalo")
    public suspend fun apiserverProfile(`value`: Output<APIServerProfileArgs>) {
        this.apiserverProfile = value
    }

    /**
     * @param value The cluster profile.
     */
    @JvmName("mjnwqvbwunukoysq")
    public suspend fun clusterProfile(`value`: Output<ClusterProfileArgs>) {
        this.clusterProfile = value
    }

    /**
     * @param value The console profile.
     */
    @JvmName("lwuatpcsgssxxwth")
    public suspend fun consoleProfile(`value`: Output<ConsoleProfileArgs>) {
        this.consoleProfile = value
    }

    /**
     * @param value The cluster ingress profiles.
     */
    @JvmName("ugwmpcihbxacelcx")
    public suspend fun ingressProfiles(`value`: Output<List<IngressProfileArgs>>) {
        this.ingressProfiles = value
    }

    @JvmName("mwcrlxatytjluqqe")
    public suspend fun ingressProfiles(vararg values: Output<IngressProfileArgs>) {
        this.ingressProfiles = Output.all(values.asList())
    }

    /**
     * @param values The cluster ingress profiles.
     */
    @JvmName("ojyxtywgoqpcjbgc")
    public suspend fun ingressProfiles(values: List<Output<IngressProfileArgs>>) {
        this.ingressProfiles = Output.all(values)
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("powqustthqqrwrcp")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The cluster master profile.
     */
    @JvmName("ihmaxwknwxajvexh")
    public suspend fun masterProfile(`value`: Output<MasterProfileArgs>) {
        this.masterProfile = value
    }

    /**
     * @param value The cluster network profile.
     */
    @JvmName("ijevuinfvdcfisnf")
    public suspend fun networkProfile(`value`: Output<NetworkProfileArgs>) {
        this.networkProfile = value
    }

    /**
     * @param value The cluster provisioning state.
     */
    @JvmName("bubeqsehltvpcrrf")
    public suspend fun provisioningState(`value`: Output<String>) {
        this.provisioningState = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vpoiddwbbgjbsxcu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the OpenShift cluster resource.
     */
    @JvmName("fkotrmoihwgjoftw")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value The cluster service principal profile.
     */
    @JvmName("ipsorvxlocluxuea")
    public suspend fun servicePrincipalProfile(`value`: Output<ServicePrincipalProfileArgs>) {
        this.servicePrincipalProfile = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("jkggtkrwymayuoks")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The cluster worker profiles.
     */
    @JvmName("ayiopasnjrjvcpxf")
    public suspend fun workerProfiles(`value`: Output<List<WorkerProfileArgs>>) {
        this.workerProfiles = value
    }

    @JvmName("xosgtyppdimihyds")
    public suspend fun workerProfiles(vararg values: Output<WorkerProfileArgs>) {
        this.workerProfiles = Output.all(values.asList())
    }

    /**
     * @param values The cluster worker profiles.
     */
    @JvmName("ehnqwsuqqhqwdies")
    public suspend fun workerProfiles(values: List<Output<WorkerProfileArgs>>) {
        this.workerProfiles = Output.all(values)
    }

    /**
     * @param value The cluster API server profile.
     */
    @JvmName("vywgabsonrbpjoqf")
    public suspend fun apiserverProfile(`value`: APIServerProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiserverProfile = mapped
    }

    /**
     * @param argument The cluster API server profile.
     */
    @JvmName("kmbyeocvhfuygafq")
    public suspend fun apiserverProfile(argument: suspend APIServerProfileArgsBuilder.() -> Unit) {
        val toBeMapped = APIServerProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.apiserverProfile = mapped
    }

    /**
     * @param value The cluster profile.
     */
    @JvmName("yfwlgfbenoytarck")
    public suspend fun clusterProfile(`value`: ClusterProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterProfile = mapped
    }

    /**
     * @param argument The cluster profile.
     */
    @JvmName("glygaxsvbhnhtnum")
    public suspend fun clusterProfile(argument: suspend ClusterProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.clusterProfile = mapped
    }

    /**
     * @param value The console profile.
     */
    @JvmName("suuqixxlyjqxhxrc")
    public suspend fun consoleProfile(`value`: ConsoleProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.consoleProfile = mapped
    }

    /**
     * @param argument The console profile.
     */
    @JvmName("mbkrpuucrgoafmmy")
    public suspend fun consoleProfile(argument: suspend ConsoleProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ConsoleProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.consoleProfile = mapped
    }

    /**
     * @param value The cluster ingress profiles.
     */
    @JvmName("ywectdmafpfyvkjg")
    public suspend fun ingressProfiles(`value`: List<IngressProfileArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ingressProfiles = mapped
    }

    /**
     * @param argument The cluster ingress profiles.
     */
    @JvmName("bbxhatsocvuwegga")
    public suspend fun ingressProfiles(argument: List<suspend IngressProfileArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IngressProfileArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ingressProfiles = mapped
    }

    /**
     * @param argument The cluster ingress profiles.
     */
    @JvmName("buoyaqdscxixuowu")
    public suspend fun ingressProfiles(
        vararg
        argument: suspend IngressProfileArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            IngressProfileArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ingressProfiles = mapped
    }

    /**
     * @param argument The cluster ingress profiles.
     */
    @JvmName("dttgqnpgbokeqalj")
    public suspend fun ingressProfiles(argument: suspend IngressProfileArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IngressProfileArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ingressProfiles = mapped
    }

    /**
     * @param values The cluster ingress profiles.
     */
    @JvmName("eqcmarltmawjwyti")
    public suspend fun ingressProfiles(vararg values: IngressProfileArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ingressProfiles = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ftlyictxrmbleicw")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The cluster master profile.
     */
    @JvmName("wlegucuhrqwgtejb")
    public suspend fun masterProfile(`value`: MasterProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterProfile = mapped
    }

    /**
     * @param argument The cluster master profile.
     */
    @JvmName("ycsicswxubxunkhv")
    public suspend fun masterProfile(argument: suspend MasterProfileArgsBuilder.() -> Unit) {
        val toBeMapped = MasterProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.masterProfile = mapped
    }

    /**
     * @param value The cluster network profile.
     */
    @JvmName("sgvqixnmgjepafkm")
    public suspend fun networkProfile(`value`: NetworkProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkProfile = mapped
    }

    /**
     * @param argument The cluster network profile.
     */
    @JvmName("hnmuscpexpxqnmfa")
    public suspend fun networkProfile(argument: suspend NetworkProfileArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkProfile = mapped
    }

    /**
     * @param value The cluster provisioning state.
     */
    @JvmName("riritqmdfxsfpgxa")
    public suspend fun provisioningState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("brnopfygomjmbgtm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the OpenShift cluster resource.
     */
    @JvmName("jxgpnbqfksxrvald")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value The cluster service principal profile.
     */
    @JvmName("eqvleigtfxtoecsk")
    public suspend fun servicePrincipalProfile(`value`: ServicePrincipalProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalProfile = mapped
    }

    /**
     * @param argument The cluster service principal profile.
     */
    @JvmName("amwcpilcpwgdnnvu")
    public suspend
    fun servicePrincipalProfile(argument: suspend ServicePrincipalProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ServicePrincipalProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.servicePrincipalProfile = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("cdswrdlyqgsmhcff")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("kpdlxtcqwupgklwr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The cluster worker profiles.
     */
    @JvmName("acxrnadnrkacjylo")
    public suspend fun workerProfiles(`value`: List<WorkerProfileArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workerProfiles = mapped
    }

    /**
     * @param argument The cluster worker profiles.
     */
    @JvmName("xiygamhsphwvumii")
    public suspend fun workerProfiles(argument: List<suspend WorkerProfileArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WorkerProfileArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.workerProfiles = mapped
    }

    /**
     * @param argument The cluster worker profiles.
     */
    @JvmName("mdrwsonpkhpoqrxr")
    public suspend fun workerProfiles(vararg argument: suspend WorkerProfileArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WorkerProfileArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.workerProfiles = mapped
    }

    /**
     * @param argument The cluster worker profiles.
     */
    @JvmName("qbrwymqmlkcuqijx")
    public suspend fun workerProfiles(argument: suspend WorkerProfileArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(WorkerProfileArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.workerProfiles = mapped
    }

    /**
     * @param values The cluster worker profiles.
     */
    @JvmName("cdomkpaiqutfnonh")
    public suspend fun workerProfiles(vararg values: WorkerProfileArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workerProfiles = mapped
    }

    internal fun build(): OpenShiftClusterArgs = OpenShiftClusterArgs(
        apiserverProfile = apiserverProfile,
        clusterProfile = clusterProfile,
        consoleProfile = consoleProfile,
        ingressProfiles = ingressProfiles,
        location = location,
        masterProfile = masterProfile,
        networkProfile = networkProfile,
        provisioningState = provisioningState,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        servicePrincipalProfile = servicePrincipalProfile,
        tags = tags,
        workerProfiles = workerProfiles,
    )
}
