@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.redhatopenshift.kotlin.inputs

import com.pulumi.azurenative.redhatopenshift.inputs.ClusterProfileArgs.builder
import com.pulumi.azurenative.redhatopenshift.kotlin.enums.FipsValidatedModules
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * ClusterProfile represents a cluster profile.
 * @property domain The domain for the cluster.
 * @property fipsValidatedModules If FIPS validated crypto modules are used
 * @property pullSecret The pull secret for the cluster.
 * @property resourceGroupId The ID of the cluster resource group.
 * @property version The version of the cluster.
 */
public data class ClusterProfileArgs(
    public val domain: Output<String>? = null,
    public val fipsValidatedModules: Output<Either<String, FipsValidatedModules>>? = null,
    public val pullSecret: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.redhatopenshift.inputs.ClusterProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.redhatopenshift.inputs.ClusterProfileArgs =
        com.pulumi.azurenative.redhatopenshift.inputs.ClusterProfileArgs.builder()
            .domain(domain?.applyValue({ args0 -> args0 }))
            .fipsValidatedModules(
                fipsValidatedModules?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .pullSecret(pullSecret?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterProfileArgs].
 */
@PulumiTagMarker
public class ClusterProfileArgsBuilder internal constructor() {
    private var domain: Output<String>? = null

    private var fipsValidatedModules: Output<Either<String, FipsValidatedModules>>? = null

    private var pullSecret: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value The domain for the cluster.
     */
    @JvmName("ddmxiswsrhnihxpc")
    public suspend fun domain(`value`: Output<String>) {
        this.domain = value
    }

    /**
     * @param value If FIPS validated crypto modules are used
     */
    @JvmName("nbognjtikpkielcs")
    public suspend fun fipsValidatedModules(`value`: Output<Either<String, FipsValidatedModules>>) {
        this.fipsValidatedModules = value
    }

    /**
     * @param value The pull secret for the cluster.
     */
    @JvmName("dstspblrtfdsxfyd")
    public suspend fun pullSecret(`value`: Output<String>) {
        this.pullSecret = value
    }

    /**
     * @param value The ID of the cluster resource group.
     */
    @JvmName("hkmpdbiweipifuml")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The version of the cluster.
     */
    @JvmName("lenvrmhodiqivgwe")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value The domain for the cluster.
     */
    @JvmName("eahwtsrclyayjdxq")
    public suspend fun domain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    /**
     * @param value If FIPS validated crypto modules are used
     */
    @JvmName("eoiewndamujnhjtw")
    public suspend fun fipsValidatedModules(`value`: Either<String, FipsValidatedModules>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fipsValidatedModules = mapped
    }

    /**
     * @param value If FIPS validated crypto modules are used
     */
    @JvmName("qorrivkmjwtxkpot")
    public fun fipsValidatedModules(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FipsValidatedModules>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fipsValidatedModules = mapped
    }

    /**
     * @param value If FIPS validated crypto modules are used
     */
    @JvmName("xdgftoamutnxlgox")
    public fun fipsValidatedModules(`value`: FipsValidatedModules) {
        val toBeMapped = Either.ofRight<String, FipsValidatedModules>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fipsValidatedModules = mapped
    }

    /**
     * @param value The pull secret for the cluster.
     */
    @JvmName("yhupejsqruqberkh")
    public suspend fun pullSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pullSecret = mapped
    }

    /**
     * @param value The ID of the cluster resource group.
     */
    @JvmName("pipyhojgegovdagb")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The version of the cluster.
     */
    @JvmName("lcqpltdlqkweygde")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): ClusterProfileArgs = ClusterProfileArgs(
        domain = domain,
        fipsValidatedModules = fipsValidatedModules,
        pullSecret = pullSecret,
        resourceGroupId = resourceGroupId,
        version = version,
    )
}
