@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.redhatopenshift.kotlin.inputs

import com.pulumi.azurenative.redhatopenshift.inputs.IngressProfileArgs.builder
import com.pulumi.azurenative.redhatopenshift.kotlin.enums.Visibility
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * IngressProfile represents an ingress profile.
 * @property ip The IP of the ingress.
 * @property name The ingress profile name.
 * @property visibility Ingress visibility.
 */
public data class IngressProfileArgs(
    public val ip: Output<String>? = null,
    public val name: Output<String>? = null,
    public val visibility: Output<Either<String, Visibility>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.redhatopenshift.inputs.IngressProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.redhatopenshift.inputs.IngressProfileArgs =
        com.pulumi.azurenative.redhatopenshift.inputs.IngressProfileArgs.builder()
            .ip(ip?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .visibility(
                visibility?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [IngressProfileArgs].
 */
@PulumiTagMarker
public class IngressProfileArgsBuilder internal constructor() {
    private var ip: Output<String>? = null

    private var name: Output<String>? = null

    private var visibility: Output<Either<String, Visibility>>? = null

    /**
     * @param value The IP of the ingress.
     */
    @JvmName("sltftdjygdpuwmkg")
    public suspend fun ip(`value`: Output<String>) {
        this.ip = value
    }

    /**
     * @param value The ingress profile name.
     */
    @JvmName("kmqasykjevbsweob")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Ingress visibility.
     */
    @JvmName("ffudtsaxrhoqgvtu")
    public suspend fun visibility(`value`: Output<Either<String, Visibility>>) {
        this.visibility = value
    }

    /**
     * @param value The IP of the ingress.
     */
    @JvmName("jsrmvobcyobhhgqj")
    public suspend fun ip(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ip = mapped
    }

    /**
     * @param value The ingress profile name.
     */
    @JvmName("rmytmtejiyxsuwle")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Ingress visibility.
     */
    @JvmName("ysavlaecfqjtniak")
    public suspend fun visibility(`value`: Either<String, Visibility>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.visibility = mapped
    }

    /**
     * @param value Ingress visibility.
     */
    @JvmName("yhybbstsqjkvmmsw")
    public fun visibility(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Visibility>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.visibility = mapped
    }

    /**
     * @param value Ingress visibility.
     */
    @JvmName("wocsihbueamyuelr")
    public fun visibility(`value`: Visibility) {
        val toBeMapped = Either.ofRight<String, Visibility>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.visibility = mapped
    }

    internal fun build(): IngressProfileArgs = IngressProfileArgs(
        ip = ip,
        name = name,
        visibility = visibility,
    )
}
