@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.relay.kotlin

import com.pulumi.azurenative.relay.HybridConnectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Description of hybrid connection resource.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2017-04-01.
 * ## Example Usage
 * ### RelayHybridConnectionCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hybridConnection = new AzureNative.Relay.HybridConnection("hybridConnection", new()
 *     {
 *         HybridConnectionName = "example-Relay-Hybrid-01",
 *         NamespaceName = "example-RelayNamespace-01",
 *         RequiresClientAuthorization = true,
 *         ResourceGroupName = "resourcegroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/relay/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := relay.NewHybridConnection(ctx, "hybridConnection", &relay.HybridConnectionArgs{
 * 			HybridConnectionName:        pulumi.String("example-Relay-Hybrid-01"),
 * 			NamespaceName:               pulumi.String("example-RelayNamespace-01"),
 * 			RequiresClientAuthorization: pulumi.Bool(true),
 * 			ResourceGroupName:           pulumi.String("resourcegroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.relay.HybridConnection;
 * import com.pulumi.azurenative.relay.HybridConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hybridConnection = new HybridConnection("hybridConnection", HybridConnectionArgs.builder()
 *             .hybridConnectionName("example-Relay-Hybrid-01")
 *             .namespaceName("example-RelayNamespace-01")
 *             .requiresClientAuthorization(true)
 *             .resourceGroupName("resourcegroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:relay:HybridConnection example-Relay-Hybrid-01 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces/{namespaceName}/hybridConnections/{hybridConnectionName}
 * ```
 * @property hybridConnectionName The hybrid connection name.
 * @property namespaceName The namespace name
 * @property requiresClientAuthorization Returns true if client authorization is needed for this hybrid connection; otherwise, false.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 * @property userMetadata The usermetadata is a placeholder to store user-defined string data for the hybrid connection endpoint. For example, it can be used to store descriptive data, such as a list of teams and their contact information. Also, user-defined configuration settings can be stored.
 */
public data class HybridConnectionArgs(
    public val hybridConnectionName: Output<String>? = null,
    public val namespaceName: Output<String>? = null,
    public val requiresClientAuthorization: Output<Boolean>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val userMetadata: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.relay.HybridConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.relay.HybridConnectionArgs =
        com.pulumi.azurenative.relay.HybridConnectionArgs.builder()
            .hybridConnectionName(hybridConnectionName?.applyValue({ args0 -> args0 }))
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .requiresClientAuthorization(requiresClientAuthorization?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .userMetadata(userMetadata?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HybridConnectionArgs].
 */
@PulumiTagMarker
public class HybridConnectionArgsBuilder internal constructor() {
    private var hybridConnectionName: Output<String>? = null

    private var namespaceName: Output<String>? = null

    private var requiresClientAuthorization: Output<Boolean>? = null

    private var resourceGroupName: Output<String>? = null

    private var userMetadata: Output<String>? = null

    /**
     * @param value The hybrid connection name.
     */
    @JvmName("vhtofujjgcxphypq")
    public suspend fun hybridConnectionName(`value`: Output<String>) {
        this.hybridConnectionName = value
    }

    /**
     * @param value The namespace name
     */
    @JvmName("xdbrsnicoyxlalxv")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value Returns true if client authorization is needed for this hybrid connection; otherwise, false.
     */
    @JvmName("dmscibbkpngxqeah")
    public suspend fun requiresClientAuthorization(`value`: Output<Boolean>) {
        this.requiresClientAuthorization = value
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("avexpqajjhnkudev")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The usermetadata is a placeholder to store user-defined string data for the hybrid connection endpoint. For example, it can be used to store descriptive data, such as a list of teams and their contact information. Also, user-defined configuration settings can be stored.
     */
    @JvmName("eymujfkrlwxlnpvw")
    public suspend fun userMetadata(`value`: Output<String>) {
        this.userMetadata = value
    }

    /**
     * @param value The hybrid connection name.
     */
    @JvmName("orstafgocdahcjtg")
    public suspend fun hybridConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hybridConnectionName = mapped
    }

    /**
     * @param value The namespace name
     */
    @JvmName("dqlrtabuvhfwdoox")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value Returns true if client authorization is needed for this hybrid connection; otherwise, false.
     */
    @JvmName("midqafthhcnpxqnn")
    public suspend fun requiresClientAuthorization(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requiresClientAuthorization = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("edrijyjqleecglny")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The usermetadata is a placeholder to store user-defined string data for the hybrid connection endpoint. For example, it can be used to store descriptive data, such as a list of teams and their contact information. Also, user-defined configuration settings can be stored.
     */
    @JvmName("ltmybogsfewrlmxb")
    public suspend fun userMetadata(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userMetadata = mapped
    }

    internal fun build(): HybridConnectionArgs = HybridConnectionArgs(
        hybridConnectionName = hybridConnectionName,
        namespaceName = namespaceName,
        requiresClientAuthorization = requiresClientAuthorization,
        resourceGroupName = resourceGroupName,
        userMetadata = userMetadata,
    )
}
