@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.relay.kotlin

import com.pulumi.azurenative.relay.HybridConnectionAuthorizationRuleArgs.builder
import com.pulumi.azurenative.relay.kotlin.enums.AccessRights
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Single item in a List or Get AuthorizationRule operation
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2017-04-01.
 * Other available API versions: 2017-04-01.
 * ## Example Usage
 * ### RelayHybridConnectionAuthorizationRuleCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hybridConnectionAuthorizationRule = new AzureNative.Relay.HybridConnectionAuthorizationRule("hybridConnectionAuthorizationRule", new()
 *     {
 *         AuthorizationRuleName = "example-RelayAuthRules-01",
 *         HybridConnectionName = "example-Relay-Hybrid-01",
 *         NamespaceName = "example-RelayNamespace-01",
 *         ResourceGroupName = "resourcegroup",
 *         Rights = new[]
 *         {
 *             "Listen",
 *             "Send",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/relay/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := relay.NewHybridConnectionAuthorizationRule(ctx, "hybridConnectionAuthorizationRule", &relay.HybridConnectionAuthorizationRuleArgs{
 * 			AuthorizationRuleName: pulumi.String("example-RelayAuthRules-01"),
 * 			HybridConnectionName:  pulumi.String("example-Relay-Hybrid-01"),
 * 			NamespaceName:         pulumi.String("example-RelayNamespace-01"),
 * 			ResourceGroupName:     pulumi.String("resourcegroup"),
 * 			Rights: pulumi.StringArray{
 * 				pulumi.String("Listen"),
 * 				pulumi.String("Send"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.relay.HybridConnectionAuthorizationRule;
 * import com.pulumi.azurenative.relay.HybridConnectionAuthorizationRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hybridConnectionAuthorizationRule = new HybridConnectionAuthorizationRule("hybridConnectionAuthorizationRule", HybridConnectionAuthorizationRuleArgs.builder()
 *             .authorizationRuleName("example-RelayAuthRules-01")
 *             .hybridConnectionName("example-Relay-Hybrid-01")
 *             .namespaceName("example-RelayNamespace-01")
 *             .resourceGroupName("resourcegroup")
 *             .rights(
 *                 "Listen",
 *                 "Send")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:relay:HybridConnectionAuthorizationRule example-RelayAuthRules-01 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces/{namespaceName}/hybridConnections/{hybridConnectionName}/authorizationRules/{authorizationRuleName}
 * ```
 * @property authorizationRuleName The authorization rule name.
 * @property hybridConnectionName The hybrid connection name.
 * @property namespaceName The namespace name
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 * @property rights The rights associated with the rule.
 */
public data class HybridConnectionAuthorizationRuleArgs(
    public val authorizationRuleName: Output<String>? = null,
    public val hybridConnectionName: Output<String>? = null,
    public val namespaceName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val rights: Output<List<Either<String, AccessRights>>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.relay.HybridConnectionAuthorizationRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.relay.HybridConnectionAuthorizationRuleArgs =
        com.pulumi.azurenative.relay.HybridConnectionAuthorizationRuleArgs.builder()
            .authorizationRuleName(authorizationRuleName?.applyValue({ args0 -> args0 }))
            .hybridConnectionName(hybridConnectionName?.applyValue({ args0 -> args0 }))
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .rights(
                rights?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            ).build()
}

/**
 * Builder for [HybridConnectionAuthorizationRuleArgs].
 */
@PulumiTagMarker
public class HybridConnectionAuthorizationRuleArgsBuilder internal constructor() {
    private var authorizationRuleName: Output<String>? = null

    private var hybridConnectionName: Output<String>? = null

    private var namespaceName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var rights: Output<List<Either<String, AccessRights>>>? = null

    /**
     * @param value The authorization rule name.
     */
    @JvmName("vjgicobxjajbcnyc")
    public suspend fun authorizationRuleName(`value`: Output<String>) {
        this.authorizationRuleName = value
    }

    /**
     * @param value The hybrid connection name.
     */
    @JvmName("nwwdloenqkqxhqqj")
    public suspend fun hybridConnectionName(`value`: Output<String>) {
        this.hybridConnectionName = value
    }

    /**
     * @param value The namespace name
     */
    @JvmName("ffsxukhplxlyriom")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("ptqvbbfhfrsokuga")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The rights associated with the rule.
     */
    @JvmName("ccfvgmtuelfbnrux")
    public suspend fun rights(`value`: Output<List<Either<String, AccessRights>>>) {
        this.rights = value
    }

    @JvmName("aeppvrqjjsqsxcbi")
    public suspend fun rights(vararg values: Output<Either<String, AccessRights>>) {
        this.rights = Output.all(values.asList())
    }

    /**
     * @param values The rights associated with the rule.
     */
    @JvmName("hejfxmuporqudbsu")
    public suspend fun rights(values: List<Output<Either<String, AccessRights>>>) {
        this.rights = Output.all(values)
    }

    /**
     * @param value The authorization rule name.
     */
    @JvmName("crdywygaxcwnggcb")
    public suspend fun authorizationRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationRuleName = mapped
    }

    /**
     * @param value The hybrid connection name.
     */
    @JvmName("ldttvndssajoeueq")
    public suspend fun hybridConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hybridConnectionName = mapped
    }

    /**
     * @param value The namespace name
     */
    @JvmName("ajuybjtjwisvbuln")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("oevsaqblohwegowh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The rights associated with the rule.
     */
    @JvmName("gefirixcopkndlvo")
    public suspend fun rights(`value`: List<Either<String, AccessRights>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rights = mapped
    }

    /**
     * @param values The rights associated with the rule.
     */
    @JvmName("qvvetnvvegfpewht")
    public suspend fun rights(vararg values: Either<String, AccessRights>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rights = mapped
    }

    internal fun build(): HybridConnectionAuthorizationRuleArgs =
        HybridConnectionAuthorizationRuleArgs(
            authorizationRuleName = authorizationRuleName,
            hybridConnectionName = hybridConnectionName,
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
            rights = rights,
        )
}
