@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.relay.kotlin

import com.pulumi.azurenative.relay.WCFRelayArgs.builder
import com.pulumi.azurenative.relay.kotlin.enums.Relaytype
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Description of the WCF relay resource.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2017-04-01.
 * Other available API versions: 2016-07-01.
 * ## Example Usage
 * ### RelayCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var wcfRelay = new AzureNative.Relay.WCFRelay("wcfRelay", new()
 *     {
 *         NamespaceName = "example-RelayNamespace-9953",
 *         RelayName = "example-Relay-Wcf-1194",
 *         RelayType = AzureNative.Relay.Relaytype.NetTcp,
 *         RequiresClientAuthorization = true,
 *         RequiresTransportSecurity = true,
 *         ResourceGroupName = "resourcegroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/relay/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := relay.NewWCFRelay(ctx, "wcfRelay", &relay.WCFRelayArgs{
 * 			NamespaceName:               pulumi.String("example-RelayNamespace-9953"),
 * 			RelayName:                   pulumi.String("example-Relay-Wcf-1194"),
 * 			RelayType:                   relay.RelaytypeNetTcp,
 * 			RequiresClientAuthorization: pulumi.Bool(true),
 * 			RequiresTransportSecurity:   pulumi.Bool(true),
 * 			ResourceGroupName:           pulumi.String("resourcegroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.relay.WCFRelay;
 * import com.pulumi.azurenative.relay.WCFRelayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var wcfRelay = new WCFRelay("wcfRelay", WCFRelayArgs.builder()
 *             .namespaceName("example-RelayNamespace-9953")
 *             .relayName("example-Relay-Wcf-1194")
 *             .relayType("NetTcp")
 *             .requiresClientAuthorization(true)
 *             .requiresTransportSecurity(true)
 *             .resourceGroupName("resourcegroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:relay:WCFRelay example-Relay-Wcf-1194 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces/{namespaceName}/wcfRelays/{relayName}
 * ```
 * @property namespaceName The namespace name
 * @property relayName The relay name.
 * @property relayType WCF relay type.
 * @property requiresClientAuthorization Returns true if client authorization is needed for this relay; otherwise, false.
 * @property requiresTransportSecurity Returns true if transport security is needed for this relay; otherwise, false.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 * @property userMetadata The usermetadata is a placeholder to store user-defined string data for the WCF Relay endpoint. For example, it can be used to store descriptive data, such as list of teams and their contact information. Also, user-defined configuration settings can be stored.
 */
public data class WCFRelayArgs(
    public val namespaceName: Output<String>? = null,
    public val relayName: Output<String>? = null,
    public val relayType: Output<Relaytype>? = null,
    public val requiresClientAuthorization: Output<Boolean>? = null,
    public val requiresTransportSecurity: Output<Boolean>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val userMetadata: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.relay.WCFRelayArgs> {
    override fun toJava(): com.pulumi.azurenative.relay.WCFRelayArgs =
        com.pulumi.azurenative.relay.WCFRelayArgs.builder()
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .relayName(relayName?.applyValue({ args0 -> args0 }))
            .relayType(relayType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .requiresClientAuthorization(requiresClientAuthorization?.applyValue({ args0 -> args0 }))
            .requiresTransportSecurity(requiresTransportSecurity?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .userMetadata(userMetadata?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WCFRelayArgs].
 */
@PulumiTagMarker
public class WCFRelayArgsBuilder internal constructor() {
    private var namespaceName: Output<String>? = null

    private var relayName: Output<String>? = null

    private var relayType: Output<Relaytype>? = null

    private var requiresClientAuthorization: Output<Boolean>? = null

    private var requiresTransportSecurity: Output<Boolean>? = null

    private var resourceGroupName: Output<String>? = null

    private var userMetadata: Output<String>? = null

    /**
     * @param value The namespace name
     */
    @JvmName("qfryuraxjalljtrw")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value The relay name.
     */
    @JvmName("cxrynymxtnuxjlyk")
    public suspend fun relayName(`value`: Output<String>) {
        this.relayName = value
    }

    /**
     * @param value WCF relay type.
     */
    @JvmName("ygugctcqkpfcddfo")
    public suspend fun relayType(`value`: Output<Relaytype>) {
        this.relayType = value
    }

    /**
     * @param value Returns true if client authorization is needed for this relay; otherwise, false.
     */
    @JvmName("ackoxsavvyjpyfkg")
    public suspend fun requiresClientAuthorization(`value`: Output<Boolean>) {
        this.requiresClientAuthorization = value
    }

    /**
     * @param value Returns true if transport security is needed for this relay; otherwise, false.
     */
    @JvmName("ymdlwolqsvknypse")
    public suspend fun requiresTransportSecurity(`value`: Output<Boolean>) {
        this.requiresTransportSecurity = value
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("ndxstaclnfhggtly")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The usermetadata is a placeholder to store user-defined string data for the WCF Relay endpoint. For example, it can be used to store descriptive data, such as list of teams and their contact information. Also, user-defined configuration settings can be stored.
     */
    @JvmName("eosurmggbwiiqlaa")
    public suspend fun userMetadata(`value`: Output<String>) {
        this.userMetadata = value
    }

    /**
     * @param value The namespace name
     */
    @JvmName("nvjhqahncfrrnwfm")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value The relay name.
     */
    @JvmName("uvlhulxmgdaqgwvh")
    public suspend fun relayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relayName = mapped
    }

    /**
     * @param value WCF relay type.
     */
    @JvmName("dhivwpcewmbdqdup")
    public suspend fun relayType(`value`: Relaytype?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relayType = mapped
    }

    /**
     * @param value Returns true if client authorization is needed for this relay; otherwise, false.
     */
    @JvmName("qklhiktaluahyxww")
    public suspend fun requiresClientAuthorization(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requiresClientAuthorization = mapped
    }

    /**
     * @param value Returns true if transport security is needed for this relay; otherwise, false.
     */
    @JvmName("wwknhbqgybtmtfvs")
    public suspend fun requiresTransportSecurity(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requiresTransportSecurity = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("qlnuhfidhmrwteuy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The usermetadata is a placeholder to store user-defined string data for the WCF Relay endpoint. For example, it can be used to store descriptive data, such as list of teams and their contact information. Also, user-defined configuration settings can be stored.
     */
    @JvmName("lcwfyyoxocyynfiw")
    public suspend fun userMetadata(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userMetadata = mapped
    }

    internal fun build(): WCFRelayArgs = WCFRelayArgs(
        namespaceName = namespaceName,
        relayName = relayName,
        relayType = relayType,
        requiresClientAuthorization = requiresClientAuthorization,
        requiresTransportSecurity = requiresTransportSecurity,
        resourceGroupName = resourceGroupName,
        userMetadata = userMetadata,
    )
}
