@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.relay.kotlin

import com.pulumi.azurenative.relay.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.relay.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [WCFRelayAuthorizationRule].
 */
@PulumiTagMarker
public class WCFRelayAuthorizationRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WCFRelayAuthorizationRuleArgs = WCFRelayAuthorizationRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WCFRelayAuthorizationRuleArgsBuilder.() -> Unit) {
        val builder = WCFRelayAuthorizationRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): WCFRelayAuthorizationRule {
        val builtJavaResource =
            com.pulumi.azurenative.relay.WCFRelayAuthorizationRule(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WCFRelayAuthorizationRule(builtJavaResource)
    }
}

/**
 * Single item in a List or Get AuthorizationRule operation
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2017-04-01.
 * Other available API versions: 2017-04-01.
 * ## Example Usage
 * ### RelayAuthorizationRuleCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var wcfRelayAuthorizationRule = new AzureNative.Relay.WCFRelayAuthorizationRule("wcfRelayAuthorizationRule", new()
 *     {
 *         AuthorizationRuleName = "example-RelayAuthRules-01",
 *         NamespaceName = "example-RelayNamespace-01",
 *         RelayName = "example-Relay-wcf-01",
 *         ResourceGroupName = "resourcegroup",
 *         Rights = new[]
 *         {
 *             "Listen",
 *             "Send",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/relay/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := relay.NewWCFRelayAuthorizationRule(ctx, "wcfRelayAuthorizationRule", &relay.WCFRelayAuthorizationRuleArgs{
 * 			AuthorizationRuleName: pulumi.String("example-RelayAuthRules-01"),
 * 			NamespaceName:         pulumi.String("example-RelayNamespace-01"),
 * 			RelayName:             pulumi.String("example-Relay-wcf-01"),
 * 			ResourceGroupName:     pulumi.String("resourcegroup"),
 * 			Rights: pulumi.StringArray{
 * 				pulumi.String("Listen"),
 * 				pulumi.String("Send"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.relay.WCFRelayAuthorizationRule;
 * import com.pulumi.azurenative.relay.WCFRelayAuthorizationRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var wcfRelayAuthorizationRule = new WCFRelayAuthorizationRule("wcfRelayAuthorizationRule", WCFRelayAuthorizationRuleArgs.builder()
 *             .authorizationRuleName("example-RelayAuthRules-01")
 *             .namespaceName("example-RelayNamespace-01")
 *             .relayName("example-Relay-wcf-01")
 *             .resourceGroupName("resourcegroup")
 *             .rights(
 *                 "Listen",
 *                 "Send")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:relay:WCFRelayAuthorizationRule example-RelayAuthRules-01 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces/{namespaceName}/wcfRelays/{relayName}/authorizationRules/{authorizationRuleName}
 * ```
 */
public class WCFRelayAuthorizationRule internal constructor(
    override val javaResource: com.pulumi.azurenative.relay.WCFRelayAuthorizationRule,
) : KotlinCustomResource(javaResource, WCFRelayAuthorizationRuleMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The rights associated with the rule.
     */
    public val rights: Output<List<String>>
        get() = javaResource.rights().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The system meta data relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WCFRelayAuthorizationRuleMapper : ResourceMapper<WCFRelayAuthorizationRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.relay.WCFRelayAuthorizationRule::class == javaResource::class

    override fun map(javaResource: Resource): WCFRelayAuthorizationRule =
        WCFRelayAuthorizationRule(
            javaResource as
                com.pulumi.azurenative.relay.WCFRelayAuthorizationRule,
        )
}

/**
 * @see [WCFRelayAuthorizationRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WCFRelayAuthorizationRule].
 */
public suspend fun wcfRelayAuthorizationRule(
    name: String,
    block: suspend WCFRelayAuthorizationRuleResourceBuilder.() -> Unit,
): WCFRelayAuthorizationRule {
    val builder = WCFRelayAuthorizationRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WCFRelayAuthorizationRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun wcfRelayAuthorizationRule(name: String): WCFRelayAuthorizationRule {
    val builder = WCFRelayAuthorizationRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
