@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.relay.kotlin.inputs

import com.pulumi.azurenative.relay.inputs.ListHybridConnectionKeysPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property authorizationRuleName The authorization rule name.
 * @property hybridConnectionName The hybrid connection name.
 * @property namespaceName The namespace name
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 */
public data class ListHybridConnectionKeysPlainArgs(
    public val authorizationRuleName: String,
    public val hybridConnectionName: String,
    public val namespaceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.relay.inputs.ListHybridConnectionKeysPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.relay.inputs.ListHybridConnectionKeysPlainArgs =
        com.pulumi.azurenative.relay.inputs.ListHybridConnectionKeysPlainArgs.builder()
            .authorizationRuleName(authorizationRuleName.let({ args0 -> args0 }))
            .hybridConnectionName(hybridConnectionName.let({ args0 -> args0 }))
            .namespaceName(namespaceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListHybridConnectionKeysPlainArgs].
 */
@PulumiTagMarker
public class ListHybridConnectionKeysPlainArgsBuilder internal constructor() {
    private var authorizationRuleName: String? = null

    private var hybridConnectionName: String? = null

    private var namespaceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The authorization rule name.
     */
    @JvmName("rbejwrldrswrqroq")
    public suspend fun authorizationRuleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.authorizationRuleName = mapped
    }

    /**
     * @param value The hybrid connection name.
     */
    @JvmName("qswgqtgwamukktgq")
    public suspend fun hybridConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.hybridConnectionName = mapped
    }

    /**
     * @param value The namespace name
     */
    @JvmName("ddaxyoxfpinhblio")
    public suspend fun namespaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.namespaceName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("wqbqwvarulvienmm")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListHybridConnectionKeysPlainArgs = ListHybridConnectionKeysPlainArgs(
        authorizationRuleName = authorizationRuleName ?: throw
            PulumiNullFieldException("authorizationRuleName"),
        hybridConnectionName = hybridConnectionName ?: throw
            PulumiNullFieldException("hybridConnectionName"),
        namespaceName = namespaceName ?: throw PulumiNullFieldException("namespaceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
