@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resourceconnector.kotlin

import com.pulumi.azurenative.resourceconnector.kotlin.outputs.AppliancePropertiesResponseInfrastructureConfig
import com.pulumi.azurenative.resourceconnector.kotlin.outputs.IdentityResponse
import com.pulumi.azurenative.resourceconnector.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.resourceconnector.kotlin.outputs.AppliancePropertiesResponseInfrastructureConfig.Companion.toKotlin as appliancePropertiesResponseInfrastructureConfigToKotlin
import com.pulumi.azurenative.resourceconnector.kotlin.outputs.IdentityResponse.Companion.toKotlin as identityResponseToKotlin
import com.pulumi.azurenative.resourceconnector.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Appliance].
 */
@PulumiTagMarker
public class ApplianceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApplianceArgs = ApplianceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApplianceArgsBuilder.() -> Unit) {
        val builder = ApplianceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Appliance {
        val builtJavaResource =
            com.pulumi.azurenative.resourceconnector.Appliance(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Appliance(builtJavaResource)
    }
}

/**
 * Appliances definition.
 * Azure REST API version: 2022-10-27. Prior API version in Azure Native 1.x: 2021-10-31-preview.
 * Other available API versions: 2021-10-31-preview.
 * ## Example Usage
 * ### Create/Update Appliance
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var appliance = new AzureNative.ResourceConnector.Appliance("appliance", new()
 *     {
 *         Distro = "AKSEdge",
 *         InfrastructureConfig = new AzureNative.ResourceConnector.Inputs.AppliancePropertiesInfrastructureConfigArgs
 *         {
 *             Provider = "VMWare",
 *         },
 *         Location = "West US",
 *         ResourceGroupName = "testresourcegroup",
 *         ResourceName = "appliance01",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/resourceconnector/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := resourceconnector.NewAppliance(ctx, "appliance", &resourceconnector.ApplianceArgs{
 * 			Distro: pulumi.String("AKSEdge"),
 * 			InfrastructureConfig: &resourceconnector.AppliancePropertiesInfrastructureConfigArgs{
 * 				Provider: pulumi.String("VMWare"),
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("testresourcegroup"),
 * 			ResourceName:      pulumi.String("appliance01"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.resourceconnector.Appliance;
 * import com.pulumi.azurenative.resourceconnector.ApplianceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var appliance = new Appliance("appliance", ApplianceArgs.builder()
 *             .distro("AKSEdge")
 *             .infrastructureConfig(Map.of("provider", "VMWare"))
 *             .location("West US")
 *             .resourceGroupName("testresourcegroup")
 *             .resourceName("appliance01")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:resourceconnector:Appliance appliance01 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ResourceConnector/appliances/{resourceName}
 * ```
 */
public class Appliance internal constructor(
    override val javaResource: com.pulumi.azurenative.resourceconnector.Appliance,
) : KotlinCustomResource(javaResource, ApplianceMapper) {
    /**
     * Represents a supported Fabric/Infra. (AKSEdge etc...).
     */
    public val distro: Output<String>?
        get() = javaResource.distro().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Identity for the resource.
     */
    public val identity: Output<IdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    identityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Contains infrastructure information about the Appliance
     */
    public val infrastructureConfig: Output<AppliancePropertiesResponseInfrastructureConfig>?
        get() = javaResource.infrastructureConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    appliancePropertiesResponseInfrastructureConfigToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The current deployment or provisioning state, which only appears in the response.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Certificates pair used to download MSI certificate from HIS. Can only be set once.
     */
    public val publicKey: Output<String>?
        get() = javaResource.publicKey().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Appliance’s health and state of connection to on-prem
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Version of the Appliance
     */
    public val version: Output<String>?
        get() = javaResource.version().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object ApplianceMapper : ResourceMapper<Appliance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.resourceconnector.Appliance::class == javaResource::class

    override fun map(javaResource: Resource): Appliance = Appliance(
        javaResource as
            com.pulumi.azurenative.resourceconnector.Appliance,
    )
}

/**
 * @see [Appliance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Appliance].
 */
public suspend fun appliance(name: String, block: suspend ApplianceResourceBuilder.() -> Unit):
    Appliance {
    val builder = ApplianceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Appliance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun appliance(name: String): Appliance {
    val builder = ApplianceResourceBuilder()
    builder.name(name)
    return builder.build()
}
