@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resourceconnector.kotlin.inputs

import com.pulumi.azurenative.resourceconnector.inputs.GetAppliancePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName Appliances name.
 */
public data class GetAppliancePlainArgs(
    public val resourceGroupName: String,
    public val resourceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.resourceconnector.inputs.GetAppliancePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.resourceconnector.inputs.GetAppliancePlainArgs =
        com.pulumi.azurenative.resourceconnector.inputs.GetAppliancePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAppliancePlainArgs].
 */
@PulumiTagMarker
public class GetAppliancePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("oecsygcxddsehwcj")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Appliances name.
     */
    @JvmName("afaxvntdtemssuni")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): GetAppliancePlainArgs = GetAppliancePlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
    )
}
