@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resourceconnector.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Appliance SSHKey definition.
 * @property certificate Certificate associated with the public key if the key is signed.
 * @property creationTimeStamp Certificate creation timestamp (Unix).
 * @property expirationTimeStamp Certificate expiration timestamp (Unix).
 * @property privateKey Private Key.
 * @property publicKey Public Key.
 */
public data class SSHKeyResponse(
    public val certificate: String,
    public val creationTimeStamp: Double,
    public val expirationTimeStamp: Double,
    public val privateKey: String,
    public val publicKey: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.resourceconnector.outputs.SSHKeyResponse):
            SSHKeyResponse = SSHKeyResponse(
            certificate = javaType.certificate(),
            creationTimeStamp = javaType.creationTimeStamp(),
            expirationTimeStamp = javaType.expirationTimeStamp(),
            privateKey = javaType.privateKey(),
            publicKey = javaType.publicKey(),
        )
    }
}
