@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin

import com.pulumi.azurenative.resources.kotlin.outputs.DeploymentPropertiesExtendedResponse
import com.pulumi.azurenative.resources.kotlin.outputs.DeploymentPropertiesExtendedResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Deployment].
 */
@PulumiTagMarker
public class DeploymentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DeploymentArgs = DeploymentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DeploymentArgsBuilder.() -> Unit) {
        val builder = DeploymentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Deployment {
        val builtJavaResource = com.pulumi.azurenative.resources.Deployment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Deployment(builtJavaResource)
    }
}

/**
 * Deployment information.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * Other available API versions: 2016-07-01, 2023-07-01.
 * ## Example Usage
 * ### Create a deployment that will deploy a template with a uri and queryString
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var deployment = new AzureNative.Resources.Deployment("deployment", new()
 *     {
 *         DeploymentName = "my-deployment",
 *         Properties = new AzureNative.Resources.Inputs.DeploymentPropertiesArgs
 *         {
 *             Mode = AzureNative.Resources.DeploymentMode.Incremental,
 *             Parameters = null,
 *             TemplateLink = new AzureNative.Resources.Inputs.TemplateLinkArgs
 *             {
 *                 QueryString = "sv=2019-02-02&st=2019-04-29T22%3A18%3A26Z&se=2019-04-30T02%3A23%3A26Z&sr=b&sp=rw&sip=168.1.5.60-168.1.5.70&spr=https&sig=xxxxxxxx0xxxxxxxxxxxxx%2bxxxxxxxxxxxxxxxxxxxx%3d",
 *                 Uri = "https://example.com/exampleTemplate.json",
 *             },
 *         },
 *         ResourceGroupName = "my-resource-group",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/resources/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := resources.NewDeployment(ctx, "deployment", &resources.DeploymentArgs{
 * 			DeploymentName: pulumi.String("my-deployment"),
 * 			Properties: resources.DeploymentPropertiesExtendedResponse{
 * 				Mode:       resources.DeploymentModeIncremental,
 * 				Parameters: nil,
 * 				TemplateLink: &resources.TemplateLinkArgs{
 * 					QueryString: pulumi.String("sv=2019-02-02&st=2019-04-29T22%3A18%3A26Z&se=2019-04-30T02%3A23%3A26Z&sr=b&sp=rw&sip=168.1.5.60-168.1.5.70&spr=https&sig=xxxxxxxx0xxxxxxxxxxxxx%2bxxxxxxxxxxxxxxxxxxxx%3d"),
 * 					Uri:         pulumi.String("https://example.com/exampleTemplate.json"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("my-resource-group"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.resources.Deployment;
 * import com.pulumi.azurenative.resources.DeploymentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var deployment = new Deployment("deployment", DeploymentArgs.builder()
 *             .deploymentName("my-deployment")
 *             .properties(Map.ofEntries(
 *                 Map.entry("mode", "Incremental"),
 *                 Map.entry("parameters", ),
 *                 Map.entry("templateLink", Map.ofEntries(
 *                     Map.entry("queryString", "sv=2019-02-02&st=2019-04-29T22%3A18%3A26Z&se=2019-04-30T02%3A23%3A26Z&sr=b&sp=rw&sip=168.1.5.60-168.1.5.70&spr=https&sig=xxxxxxxx0xxxxxxxxxxxxx%2bxxxxxxxxxxxxxxxxxxxx%3d"),
 *                     Map.entry("uri", "https://example.com/exampleTemplate.json")
 *                 ))
 *             ))
 *             .resourceGroupName("my-resource-group")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a deployment that will deploy a templateSpec with the given resourceId
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var deployment = new AzureNative.Resources.Deployment("deployment", new()
 *     {
 *         DeploymentName = "my-deployment",
 *         Properties = new AzureNative.Resources.Inputs.DeploymentPropertiesArgs
 *         {
 *             Mode = AzureNative.Resources.DeploymentMode.Incremental,
 *             Parameters = null,
 *             TemplateLink = new AzureNative.Resources.Inputs.TemplateLinkArgs
 *             {
 *                 Id = "/subscriptions/00000000-0000-0000-0000-000000000001/resourceGroups/my-resource-group/providers/Microsoft.Resources/TemplateSpecs/TemplateSpec-Name/versions/v1",
 *             },
 *         },
 *         ResourceGroupName = "my-resource-group",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/resources/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := resources.NewDeployment(ctx, "deployment", &resources.DeploymentArgs{
 * 			DeploymentName: pulumi.String("my-deployment"),
 * 			Properties: resources.DeploymentPropertiesExtendedResponse{
 * 				Mode:       resources.DeploymentModeIncremental,
 * 				Parameters: nil,
 * 				TemplateLink: &resources.TemplateLinkArgs{
 * 					Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000001/resourceGroups/my-resource-group/providers/Microsoft.Resources/TemplateSpecs/TemplateSpec-Name/versions/v1"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("my-resource-group"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.resources.Deployment;
 * import com.pulumi.azurenative.resources.DeploymentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var deployment = new Deployment("deployment", DeploymentArgs.builder()
 *             .deploymentName("my-deployment")
 *             .properties(Map.ofEntries(
 *                 Map.entry("mode", "Incremental"),
 *                 Map.entry("parameters", ),
 *                 Map.entry("templateLink", Map.of("id", "/subscriptions/00000000-0000-0000-0000-000000000001/resourceGroups/my-resource-group/providers/Microsoft.Resources/TemplateSpecs/TemplateSpec-Name/versions/v1"))
 *             ))
 *             .resourceGroupName("my-resource-group")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a deployment that will redeploy another deployment on failure
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var deployment = new AzureNative.Resources.Deployment("deployment", new()
 *     {
 *         DeploymentName = "my-deployment",
 *         Properties = new AzureNative.Resources.Inputs.DeploymentPropertiesArgs
 *         {
 *             Mode = AzureNative.Resources.DeploymentMode.Complete,
 *             OnErrorDeployment = new AzureNative.Resources.Inputs.OnErrorDeploymentArgs
 *             {
 *                 DeploymentName = "name-of-deployment-to-use",
 *                 Type = AzureNative.Resources.OnErrorDeploymentType.SpecificDeployment,
 *             },
 *             Parameters = null,
 *             TemplateLink = new AzureNative.Resources.Inputs.TemplateLinkArgs
 *             {
 *                 Uri = "https://example.com/exampleTemplate.json",
 *             },
 *         },
 *         ResourceGroupName = "my-resource-group",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/resources/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := resources.NewDeployment(ctx, "deployment", &resources.DeploymentArgs{
 * 			DeploymentName: pulumi.String("my-deployment"),
 * 			Properties: resources.DeploymentPropertiesExtendedResponse{
 * 				Mode: resources.DeploymentModeComplete,
 * 				OnErrorDeployment: &resources.OnErrorDeploymentArgs{
 * 					DeploymentName: pulumi.String("name-of-deployment-to-use"),
 * 					Type:           resources.OnErrorDeploymentTypeSpecificDeployment,
 * 				},
 * 				Parameters: nil,
 * 				TemplateLink: &resources.TemplateLinkArgs{
 * 					Uri: pulumi.String("https://example.com/exampleTemplate.json"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("my-resource-group"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.resources.Deployment;
 * import com.pulumi.azurenative.resources.DeploymentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var deployment = new Deployment("deployment", DeploymentArgs.builder()
 *             .deploymentName("my-deployment")
 *             .properties(Map.ofEntries(
 *                 Map.entry("mode", "Complete"),
 *                 Map.entry("onErrorDeployment", Map.ofEntries(
 *                     Map.entry("deploymentName", "name-of-deployment-to-use"),
 *                     Map.entry("type", "SpecificDeployment")
 *                 )),
 *                 Map.entry("parameters", ),
 *                 Map.entry("templateLink", Map.of("uri", "https://example.com/exampleTemplate.json"))
 *             ))
 *             .resourceGroupName("my-resource-group")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a deployment that will redeploy the last successful deployment on failure
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var deployment = new AzureNative.Resources.Deployment("deployment", new()
 *     {
 *         DeploymentName = "my-deployment",
 *         Properties = new AzureNative.Resources.Inputs.DeploymentPropertiesArgs
 *         {
 *             Mode = AzureNative.Resources.DeploymentMode.Complete,
 *             OnErrorDeployment = new AzureNative.Resources.Inputs.OnErrorDeploymentArgs
 *             {
 *                 Type = AzureNative.Resources.OnErrorDeploymentType.LastSuccessful,
 *             },
 *             Parameters = null,
 *             TemplateLink = new AzureNative.Resources.Inputs.TemplateLinkArgs
 *             {
 *                 Uri = "https://example.com/exampleTemplate.json",
 *             },
 *         },
 *         ResourceGroupName = "my-resource-group",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/resources/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := resources.NewDeployment(ctx, "deployment", &resources.DeploymentArgs{
 * 			DeploymentName: pulumi.String("my-deployment"),
 * 			Properties: resources.DeploymentPropertiesExtendedResponse{
 * 				Mode: resources.DeploymentModeComplete,
 * 				OnErrorDeployment: &resources.OnErrorDeploymentArgs{
 * 					Type: resources.OnErrorDeploymentTypeLastSuccessful,
 * 				},
 * 				Parameters: nil,
 * 				TemplateLink: &resources.TemplateLinkArgs{
 * 					Uri: pulumi.String("https://example.com/exampleTemplate.json"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("my-resource-group"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.resources.Deployment;
 * import com.pulumi.azurenative.resources.DeploymentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var deployment = new Deployment("deployment", DeploymentArgs.builder()
 *             .deploymentName("my-deployment")
 *             .properties(Map.ofEntries(
 *                 Map.entry("mode", "Complete"),
 *                 Map.entry("onErrorDeployment", Map.of("type", "LastSuccessful")),
 *                 Map.entry("parameters", ),
 *                 Map.entry("templateLink", Map.of("uri", "https://example.com/exampleTemplate.json"))
 *             ))
 *             .resourceGroupName("my-resource-group")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:resources:Deployment my-deployment /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}
 * ```
 */
public class Deployment internal constructor(
    override val javaResource: com.pulumi.azurenative.resources.Deployment,
) : KotlinCustomResource(javaResource, DeploymentMapper) {
    /**
     * the location of the deployment.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the deployment.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Deployment properties.
     */
    public val properties: Output<DeploymentPropertiesExtendedResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Deployment tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the deployment.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DeploymentMapper : ResourceMapper<Deployment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.resources.Deployment::class == javaResource::class

    override fun map(javaResource: Resource): Deployment = Deployment(
        javaResource as
            com.pulumi.azurenative.resources.Deployment,
    )
}

/**
 * @see [Deployment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Deployment].
 */
public suspend fun deployment(name: String, block: suspend DeploymentResourceBuilder.() -> Unit):
    Deployment {
    val builder = DeploymentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Deployment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun deployment(name: String): Deployment {
    val builder = DeploymentResourceBuilder()
    builder.name(name)
    return builder.build()
}
