@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin

import com.pulumi.azurenative.resources.DeploymentArgs.builder
import com.pulumi.azurenative.resources.kotlin.inputs.DeploymentPropertiesArgs
import com.pulumi.azurenative.resources.kotlin.inputs.DeploymentPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Deployment information.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * Other available API versions: 2016-07-01, 2023-07-01.
 * ## Example Usage
 * ### Create a deployment that will deploy a template with a uri and queryString
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var deployment = new AzureNative.Resources.Deployment("deployment", new()
 *     {
 *         DeploymentName = "my-deployment",
 *         Properties = new AzureNative.Resources.Inputs.DeploymentPropertiesArgs
 *         {
 *             Mode = AzureNative.Resources.DeploymentMode.Incremental,
 *             Parameters = null,
 *             TemplateLink = new AzureNative.Resources.Inputs.TemplateLinkArgs
 *             {
 *                 QueryString = "sv=2019-02-02&st=2019-04-29T22%3A18%3A26Z&se=2019-04-30T02%3A23%3A26Z&sr=b&sp=rw&sip=168.1.5.60-168.1.5.70&spr=https&sig=xxxxxxxx0xxxxxxxxxxxxx%2bxxxxxxxxxxxxxxxxxxxx%3d",
 *                 Uri = "https://example.com/exampleTemplate.json",
 *             },
 *         },
 *         ResourceGroupName = "my-resource-group",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/resources/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := resources.NewDeployment(ctx, "deployment", &resources.DeploymentArgs{
 * 			DeploymentName: pulumi.String("my-deployment"),
 * 			Properties: resources.DeploymentPropertiesExtendedResponse{
 * 				Mode:       resources.DeploymentModeIncremental,
 * 				Parameters: nil,
 * 				TemplateLink: &resources.TemplateLinkArgs{
 * 					QueryString: pulumi.String("sv=2019-02-02&st=2019-04-29T22%3A18%3A26Z&se=2019-04-30T02%3A23%3A26Z&sr=b&sp=rw&sip=168.1.5.60-168.1.5.70&spr=https&sig=xxxxxxxx0xxxxxxxxxxxxx%2bxxxxxxxxxxxxxxxxxxxx%3d"),
 * 					Uri:         pulumi.String("https://example.com/exampleTemplate.json"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("my-resource-group"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.resources.Deployment;
 * import com.pulumi.azurenative.resources.DeploymentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var deployment = new Deployment("deployment", DeploymentArgs.builder()
 *             .deploymentName("my-deployment")
 *             .properties(Map.ofEntries(
 *                 Map.entry("mode", "Incremental"),
 *                 Map.entry("parameters", ),
 *                 Map.entry("templateLink", Map.ofEntries(
 *                     Map.entry("queryString", "sv=2019-02-02&st=2019-04-29T22%3A18%3A26Z&se=2019-04-30T02%3A23%3A26Z&sr=b&sp=rw&sip=168.1.5.60-168.1.5.70&spr=https&sig=xxxxxxxx0xxxxxxxxxxxxx%2bxxxxxxxxxxxxxxxxxxxx%3d"),
 *                     Map.entry("uri", "https://example.com/exampleTemplate.json")
 *                 ))
 *             ))
 *             .resourceGroupName("my-resource-group")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a deployment that will deploy a templateSpec with the given resourceId
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var deployment = new AzureNative.Resources.Deployment("deployment", new()
 *     {
 *         DeploymentName = "my-deployment",
 *         Properties = new AzureNative.Resources.Inputs.DeploymentPropertiesArgs
 *         {
 *             Mode = AzureNative.Resources.DeploymentMode.Incremental,
 *             Parameters = null,
 *             TemplateLink = new AzureNative.Resources.Inputs.TemplateLinkArgs
 *             {
 *                 Id = "/subscriptions/00000000-0000-0000-0000-000000000001/resourceGroups/my-resource-group/providers/Microsoft.Resources/TemplateSpecs/TemplateSpec-Name/versions/v1",
 *             },
 *         },
 *         ResourceGroupName = "my-resource-group",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/resources/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := resources.NewDeployment(ctx, "deployment", &resources.DeploymentArgs{
 * 			DeploymentName: pulumi.String("my-deployment"),
 * 			Properties: resources.DeploymentPropertiesExtendedResponse{
 * 				Mode:       resources.DeploymentModeIncremental,
 * 				Parameters: nil,
 * 				TemplateLink: &resources.TemplateLinkArgs{
 * 					Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000001/resourceGroups/my-resource-group/providers/Microsoft.Resources/TemplateSpecs/TemplateSpec-Name/versions/v1"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("my-resource-group"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.resources.Deployment;
 * import com.pulumi.azurenative.resources.DeploymentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var deployment = new Deployment("deployment", DeploymentArgs.builder()
 *             .deploymentName("my-deployment")
 *             .properties(Map.ofEntries(
 *                 Map.entry("mode", "Incremental"),
 *                 Map.entry("parameters", ),
 *                 Map.entry("templateLink", Map.of("id", "/subscriptions/00000000-0000-0000-0000-000000000001/resourceGroups/my-resource-group/providers/Microsoft.Resources/TemplateSpecs/TemplateSpec-Name/versions/v1"))
 *             ))
 *             .resourceGroupName("my-resource-group")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a deployment that will redeploy another deployment on failure
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var deployment = new AzureNative.Resources.Deployment("deployment", new()
 *     {
 *         DeploymentName = "my-deployment",
 *         Properties = new AzureNative.Resources.Inputs.DeploymentPropertiesArgs
 *         {
 *             Mode = AzureNative.Resources.DeploymentMode.Complete,
 *             OnErrorDeployment = new AzureNative.Resources.Inputs.OnErrorDeploymentArgs
 *             {
 *                 DeploymentName = "name-of-deployment-to-use",
 *                 Type = AzureNative.Resources.OnErrorDeploymentType.SpecificDeployment,
 *             },
 *             Parameters = null,
 *             TemplateLink = new AzureNative.Resources.Inputs.TemplateLinkArgs
 *             {
 *                 Uri = "https://example.com/exampleTemplate.json",
 *             },
 *         },
 *         ResourceGroupName = "my-resource-group",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/resources/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := resources.NewDeployment(ctx, "deployment", &resources.DeploymentArgs{
 * 			DeploymentName: pulumi.String("my-deployment"),
 * 			Properties: resources.DeploymentPropertiesExtendedResponse{
 * 				Mode: resources.DeploymentModeComplete,
 * 				OnErrorDeployment: &resources.OnErrorDeploymentArgs{
 * 					DeploymentName: pulumi.String("name-of-deployment-to-use"),
 * 					Type:           resources.OnErrorDeploymentTypeSpecificDeployment,
 * 				},
 * 				Parameters: nil,
 * 				TemplateLink: &resources.TemplateLinkArgs{
 * 					Uri: pulumi.String("https://example.com/exampleTemplate.json"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("my-resource-group"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.resources.Deployment;
 * import com.pulumi.azurenative.resources.DeploymentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var deployment = new Deployment("deployment", DeploymentArgs.builder()
 *             .deploymentName("my-deployment")
 *             .properties(Map.ofEntries(
 *                 Map.entry("mode", "Complete"),
 *                 Map.entry("onErrorDeployment", Map.ofEntries(
 *                     Map.entry("deploymentName", "name-of-deployment-to-use"),
 *                     Map.entry("type", "SpecificDeployment")
 *                 )),
 *                 Map.entry("parameters", ),
 *                 Map.entry("templateLink", Map.of("uri", "https://example.com/exampleTemplate.json"))
 *             ))
 *             .resourceGroupName("my-resource-group")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a deployment that will redeploy the last successful deployment on failure
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var deployment = new AzureNative.Resources.Deployment("deployment", new()
 *     {
 *         DeploymentName = "my-deployment",
 *         Properties = new AzureNative.Resources.Inputs.DeploymentPropertiesArgs
 *         {
 *             Mode = AzureNative.Resources.DeploymentMode.Complete,
 *             OnErrorDeployment = new AzureNative.Resources.Inputs.OnErrorDeploymentArgs
 *             {
 *                 Type = AzureNative.Resources.OnErrorDeploymentType.LastSuccessful,
 *             },
 *             Parameters = null,
 *             TemplateLink = new AzureNative.Resources.Inputs.TemplateLinkArgs
 *             {
 *                 Uri = "https://example.com/exampleTemplate.json",
 *             },
 *         },
 *         ResourceGroupName = "my-resource-group",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/resources/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := resources.NewDeployment(ctx, "deployment", &resources.DeploymentArgs{
 * 			DeploymentName: pulumi.String("my-deployment"),
 * 			Properties: resources.DeploymentPropertiesExtendedResponse{
 * 				Mode: resources.DeploymentModeComplete,
 * 				OnErrorDeployment: &resources.OnErrorDeploymentArgs{
 * 					Type: resources.OnErrorDeploymentTypeLastSuccessful,
 * 				},
 * 				Parameters: nil,
 * 				TemplateLink: &resources.TemplateLinkArgs{
 * 					Uri: pulumi.String("https://example.com/exampleTemplate.json"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("my-resource-group"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.resources.Deployment;
 * import com.pulumi.azurenative.resources.DeploymentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var deployment = new Deployment("deployment", DeploymentArgs.builder()
 *             .deploymentName("my-deployment")
 *             .properties(Map.ofEntries(
 *                 Map.entry("mode", "Complete"),
 *                 Map.entry("onErrorDeployment", Map.of("type", "LastSuccessful")),
 *                 Map.entry("parameters", ),
 *                 Map.entry("templateLink", Map.of("uri", "https://example.com/exampleTemplate.json"))
 *             ))
 *             .resourceGroupName("my-resource-group")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:resources:Deployment my-deployment /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}
 * ```
 * @property deploymentName The name of the deployment.
 * @property location The location to store the deployment data.
 * @property properties The deployment properties.
 * @property resourceGroupName The name of the resource group to deploy the resources to. The name is case insensitive. The resource group must already exist.
 * @property tags Deployment tags
 */
public data class DeploymentArgs(
    public val deploymentName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<DeploymentPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.resources.DeploymentArgs> {
    override fun toJava(): com.pulumi.azurenative.resources.DeploymentArgs =
        com.pulumi.azurenative.resources.DeploymentArgs.builder()
            .deploymentName(deploymentName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DeploymentArgs].
 */
@PulumiTagMarker
public class DeploymentArgsBuilder internal constructor() {
    private var deploymentName: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<DeploymentPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the deployment.
     */
    @JvmName("oseobmsuqegmgfsb")
    public suspend fun deploymentName(`value`: Output<String>) {
        this.deploymentName = value
    }

    /**
     * @param value The location to store the deployment data.
     */
    @JvmName("sjjoxqibtxjlmtdu")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The deployment properties.
     */
    @JvmName("gwpqkbdoyrhiqaag")
    public suspend fun properties(`value`: Output<DeploymentPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group to deploy the resources to. The name is case insensitive. The resource group must already exist.
     */
    @JvmName("ufbxgcdklrgfggci")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Deployment tags
     */
    @JvmName("qtohevbxyiiwbuxx")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the deployment.
     */
    @JvmName("ymyroacbecuvyebx")
    public suspend fun deploymentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentName = mapped
    }

    /**
     * @param value The location to store the deployment data.
     */
    @JvmName("nxvosdkoanjiioey")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The deployment properties.
     */
    @JvmName("ecubrjqfujmnpffu")
    public suspend fun properties(`value`: DeploymentPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The deployment properties.
     */
    @JvmName("uaigpxmptaynefth")
    public suspend fun properties(argument: suspend DeploymentPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = DeploymentPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group to deploy the resources to. The name is case insensitive. The resource group must already exist.
     */
    @JvmName("rmvonmavyphgkkdm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Deployment tags
     */
    @JvmName("ddqgveoqdvebiupo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Deployment tags
     */
    @JvmName("sxpmtleqavcjmylv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DeploymentArgs = DeploymentArgs(
        deploymentName = deploymentName,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
