@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin

import com.pulumi.azurenative.resources.DeploymentAtSubscriptionScopeArgs.builder
import com.pulumi.azurenative.resources.kotlin.inputs.DeploymentPropertiesArgs
import com.pulumi.azurenative.resources.kotlin.inputs.DeploymentPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Deployment information.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * Other available API versions: 2023-07-01.
 * ## Example Usage
 * ### Create a deployment that will deploy a templateSpec with the given resourceId
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var deploymentAtSubscriptionScope = new AzureNative.Resources.DeploymentAtSubscriptionScope("deploymentAtSubscriptionScope", new()
 *     {
 *         DeploymentName = "my-deployment",
 *         Location = "eastus",
 *         Properties = new AzureNative.Resources.Inputs.DeploymentPropertiesArgs
 *         {
 *             Mode = AzureNative.Resources.DeploymentMode.Incremental,
 *             Parameters = null,
 *             TemplateLink = new AzureNative.Resources.Inputs.TemplateLinkArgs
 *             {
 *                 Id = "/subscriptions/00000000-0000-0000-0000-000000000001/resourceGroups/my-resource-group/providers/Microsoft.Resources/TemplateSpecs/TemplateSpec-Name/versions/v1",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/resources/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := resources.NewDeploymentAtSubscriptionScope(ctx, "deploymentAtSubscriptionScope", &resources.DeploymentAtSubscriptionScopeArgs{
 * 			DeploymentName: pulumi.String("my-deployment"),
 * 			Location:       pulumi.String("eastus"),
 * 			Properties: resources.DeploymentPropertiesExtendedResponse{
 * 				Mode:       resources.DeploymentModeIncremental,
 * 				Parameters: nil,
 * 				TemplateLink: &resources.TemplateLinkArgs{
 * 					Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000001/resourceGroups/my-resource-group/providers/Microsoft.Resources/TemplateSpecs/TemplateSpec-Name/versions/v1"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.resources.DeploymentAtSubscriptionScope;
 * import com.pulumi.azurenative.resources.DeploymentAtSubscriptionScopeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var deploymentAtSubscriptionScope = new DeploymentAtSubscriptionScope("deploymentAtSubscriptionScope", DeploymentAtSubscriptionScopeArgs.builder()
 *             .deploymentName("my-deployment")
 *             .location("eastus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("mode", "Incremental"),
 *                 Map.entry("parameters", ),
 *                 Map.entry("templateLink", Map.of("id", "/subscriptions/00000000-0000-0000-0000-000000000001/resourceGroups/my-resource-group/providers/Microsoft.Resources/TemplateSpecs/TemplateSpec-Name/versions/v1"))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:resources:DeploymentAtSubscriptionScope my-deployment /subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}
 * ```
 * @property deploymentName The name of the deployment.
 * @property location The location to store the deployment data.
 * @property properties The deployment properties.
 * @property tags Deployment tags
 */
public data class DeploymentAtSubscriptionScopeArgs(
    public val deploymentName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<DeploymentPropertiesArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.resources.DeploymentAtSubscriptionScopeArgs> {
    override fun toJava(): com.pulumi.azurenative.resources.DeploymentAtSubscriptionScopeArgs =
        com.pulumi.azurenative.resources.DeploymentAtSubscriptionScopeArgs.builder()
            .deploymentName(deploymentName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DeploymentAtSubscriptionScopeArgs].
 */
@PulumiTagMarker
public class DeploymentAtSubscriptionScopeArgsBuilder internal constructor() {
    private var deploymentName: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<DeploymentPropertiesArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the deployment.
     */
    @JvmName("xfipgomrysiiwdwm")
    public suspend fun deploymentName(`value`: Output<String>) {
        this.deploymentName = value
    }

    /**
     * @param value The location to store the deployment data.
     */
    @JvmName("gpgjmvsflsupkqyc")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The deployment properties.
     */
    @JvmName("uooulgypkpdrobjb")
    public suspend fun properties(`value`: Output<DeploymentPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Deployment tags
     */
    @JvmName("efdaxlcylhcqctom")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the deployment.
     */
    @JvmName("kpmyanicxahklxoo")
    public suspend fun deploymentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentName = mapped
    }

    /**
     * @param value The location to store the deployment data.
     */
    @JvmName("qyolsmlrdnxkyost")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The deployment properties.
     */
    @JvmName("rtmsilsgevewhsdd")
    public suspend fun properties(`value`: DeploymentPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The deployment properties.
     */
    @JvmName("dtiorqbyiyiwwuup")
    public suspend fun properties(argument: suspend DeploymentPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = DeploymentPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Deployment tags
     */
    @JvmName("pwqqbgsukghhnmif")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Deployment tags
     */
    @JvmName("axpeyxykpllfgsck")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DeploymentAtSubscriptionScopeArgs = DeploymentAtSubscriptionScopeArgs(
        deploymentName = deploymentName,
        location = location,
        properties = properties,
        tags = tags,
    )
}
