@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin

import com.pulumi.azurenative.resources.ResourceArgs.builder
import com.pulumi.azurenative.resources.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.resources.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.resources.kotlin.inputs.IdentityArgs
import com.pulumi.azurenative.resources.kotlin.inputs.IdentityArgsBuilder
import com.pulumi.azurenative.resources.kotlin.inputs.PlanArgs
import com.pulumi.azurenative.resources.kotlin.inputs.PlanArgsBuilder
import com.pulumi.azurenative.resources.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.resources.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource information.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2019-05-01.
 * Other available API versions: 2015-11-01, 2023-07-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:resources:Resource myresource1 /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}
 * ```
 * @property extendedLocation Resource extended location.
 * @property identity The identity of the resource.
 * @property kind The kind of the resource.
 * @property location Resource location
 * @property managedBy ID of the resource that manages this resource.
 * @property parentResourcePath The parent resource identity.
 * @property plan The plan of the resource.
 * @property properties The resource properties.
 * @property resourceGroupName The name of the resource group for the resource. The name is case insensitive.
 * @property resourceName The name of the resource to create.
 * @property resourceProviderNamespace The namespace of the resource provider.
 * @property resourceType The resource type of the resource to create.
 * @property sku The SKU of the resource.
 * @property tags Resource tags
 */
public data class ResourceArgs(
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val identity: Output<IdentityArgs>? = null,
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val managedBy: Output<String>? = null,
    public val parentResourcePath: Output<String>? = null,
    public val plan: Output<PlanArgs>? = null,
    public val properties: Output<Any>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val resourceProviderNamespace: Output<String>? = null,
    public val resourceType: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.resources.ResourceArgs> {
    override fun toJava(): com.pulumi.azurenative.resources.ResourceArgs =
        com.pulumi.azurenative.resources.ResourceArgs.builder()
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .managedBy(managedBy?.applyValue({ args0 -> args0 }))
            .parentResourcePath(parentResourcePath?.applyValue({ args0 -> args0 }))
            .plan(plan?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .properties(properties?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .resourceProviderNamespace(resourceProviderNamespace?.applyValue({ args0 -> args0 }))
            .resourceType(resourceType?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ResourceArgs].
 */
@PulumiTagMarker
public class ResourceArgsBuilder internal constructor() {
    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var identity: Output<IdentityArgs>? = null

    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var managedBy: Output<String>? = null

    private var parentResourcePath: Output<String>? = null

    private var plan: Output<PlanArgs>? = null

    private var properties: Output<Any>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var resourceProviderNamespace: Output<String>? = null

    private var resourceType: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Resource extended location.
     */
    @JvmName("iefoxyfpttayiayw")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The identity of the resource.
     */
    @JvmName("kkfhldabcbkmnbwm")
    public suspend fun identity(`value`: Output<IdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The kind of the resource.
     */
    @JvmName("yngordjadmkcjaue")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("marfehutfawytejw")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value ID of the resource that manages this resource.
     */
    @JvmName("xhxmsoubaiqiduuk")
    public suspend fun managedBy(`value`: Output<String>) {
        this.managedBy = value
    }

    /**
     * @param value The parent resource identity.
     */
    @JvmName("eqfyosjoxavrdere")
    public suspend fun parentResourcePath(`value`: Output<String>) {
        this.parentResourcePath = value
    }

    /**
     * @param value The plan of the resource.
     */
    @JvmName("bqwmmibyvjjdegem")
    public suspend fun plan(`value`: Output<PlanArgs>) {
        this.plan = value
    }

    /**
     * @param value The resource properties.
     */
    @JvmName("scpmslhgknrqmtth")
    public suspend fun properties(`value`: Output<Any>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group for the resource. The name is case insensitive.
     */
    @JvmName("fnjemgficyuwnpsl")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the resource to create.
     */
    @JvmName("wpdsyfkpwlhewgkx")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value The namespace of the resource provider.
     */
    @JvmName("nlfrxnsphrjotfke")
    public suspend fun resourceProviderNamespace(`value`: Output<String>) {
        this.resourceProviderNamespace = value
    }

    /**
     * @param value The resource type of the resource to create.
     */
    @JvmName("atvblfmyaelkfdwj")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value The SKU of the resource.
     */
    @JvmName("hcvjmwegwdmflxai")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("iauwgvehjxdiwjos")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Resource extended location.
     */
    @JvmName("rxgolooxtgyqithc")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument Resource extended location.
     */
    @JvmName("qeecixcsmmjdpsdg")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The identity of the resource.
     */
    @JvmName("xsftoferdydnaobw")
    public suspend fun identity(`value`: IdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity of the resource.
     */
    @JvmName("lcjrbrouocppbqvd")
    public suspend fun identity(argument: suspend IdentityArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The kind of the resource.
     */
    @JvmName("iaalnhbvslhotjad")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("acmxphdxeyhuyham")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value ID of the resource that manages this resource.
     */
    @JvmName("cpwrwsqhjxqxnvsr")
    public suspend fun managedBy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedBy = mapped
    }

    /**
     * @param value The parent resource identity.
     */
    @JvmName("gufiwbkltdsaaksq")
    public suspend fun parentResourcePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parentResourcePath = mapped
    }

    /**
     * @param value The plan of the resource.
     */
    @JvmName("ottdonaivcpdslnp")
    public suspend fun plan(`value`: PlanArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.plan = mapped
    }

    /**
     * @param argument The plan of the resource.
     */
    @JvmName("iuqbgojgmoobytfl")
    public suspend fun plan(argument: suspend PlanArgsBuilder.() -> Unit) {
        val toBeMapped = PlanArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.plan = mapped
    }

    /**
     * @param value The resource properties.
     */
    @JvmName("wnojpnmwpvbxurwg")
    public suspend fun properties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group for the resource. The name is case insensitive.
     */
    @JvmName("lokgiiosmyjofynd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the resource to create.
     */
    @JvmName("setlucqytunnbbyv")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value The namespace of the resource provider.
     */
    @JvmName("yhywwaloobciayjk")
    public suspend fun resourceProviderNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceProviderNamespace = mapped
    }

    /**
     * @param value The resource type of the resource to create.
     */
    @JvmName("vghgahbxyawwxjid")
    public suspend fun resourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    /**
     * @param value The SKU of the resource.
     */
    @JvmName("kavytyctrvdfeklf")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The SKU of the resource.
     */
    @JvmName("kwuruvtlpsfmvqkl")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("xanxsxxsrxihgdbr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("lucmptlyqoofjscf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ResourceArgs = ResourceArgs(
        extendedLocation = extendedLocation,
        identity = identity,
        kind = kind,
        location = location,
        managedBy = managedBy,
        parentResourcePath = parentResourcePath,
        plan = plan,
        properties = properties,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        resourceProviderNamespace = resourceProviderNamespace,
        resourceType = resourceType,
        sku = sku,
        tags = tags,
    )
}
