@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The mode that is used to deploy resources. This value can be either Incremental or Complete. In Incremental mode, resources are deployed without deleting existing resources that are not included in the template. In Complete mode, resources are deployed and existing resources in the resource group that are not included in the template are deleted. Be careful when using Complete mode as you may unintentionally delete resources.
 */
public enum class DeploymentMode(
    public val javaValue: com.pulumi.azurenative.resources.enums.DeploymentMode,
) : ConvertibleToJava<com.pulumi.azurenative.resources.enums.DeploymentMode> {
    Incremental(com.pulumi.azurenative.resources.enums.DeploymentMode.Incremental),
    Complete(com.pulumi.azurenative.resources.enums.DeploymentMode.Complete),
    ;

    override fun toJava(): com.pulumi.azurenative.resources.enums.DeploymentMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.resources.enums.DeploymentMode):
            DeploymentMode = DeploymentMode.values().first { it.javaValue == javaType }
    }
}
