@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.inputs

import com.pulumi.azurenative.resources.inputs.DeploymentPropertiesArgs.builder
import com.pulumi.azurenative.resources.kotlin.enums.DeploymentMode
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Deployment properties.
 * @property debugSetting The debug setting of the deployment.
 * @property expressionEvaluationOptions Specifies whether template expressions are evaluated within the scope of the parent template or nested template. Only applicable to nested templates. If not specified, default value is outer.
 * @property mode The mode that is used to deploy resources. This value can be either Incremental or Complete. In Incremental mode, resources are deployed without deleting existing resources that are not included in the template. In Complete mode, resources are deployed and existing resources in the resource group that are not included in the template are deleted. Be careful when using Complete mode as you may unintentionally delete resources.
 * @property onErrorDeployment The deployment on error behavior.
 * @property parameters Name and value pairs that define the deployment parameters for the template. You use this element when you want to provide the parameter values directly in the request rather than link to an existing parameter file. Use either the parametersLink property or the parameters property, but not both. It can be a JObject or a well formed JSON string.
 * @property parametersLink The URI of parameters file. You use this element to link to an existing parameters file. Use either the parametersLink property or the parameters property, but not both.
 * @property template The template content. You use this element when you want to pass the template syntax directly in the request rather than link to an existing template. It can be a JObject or well-formed JSON string. Use either the templateLink property or the template property, but not both.
 * @property templateLink The URI of the template. Use either the templateLink property or the template property, but not both.
 */
public data class DeploymentPropertiesArgs(
    public val debugSetting: Output<DebugSettingArgs>? = null,
    public val expressionEvaluationOptions: Output<ExpressionEvaluationOptionsArgs>? = null,
    public val mode: Output<DeploymentMode>,
    public val onErrorDeployment: Output<OnErrorDeploymentArgs>? = null,
    public val parameters: Output<Map<String, DeploymentParameterArgs>>? = null,
    public val parametersLink: Output<ParametersLinkArgs>? = null,
    public val template: Output<Any>? = null,
    public val templateLink: Output<TemplateLinkArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.resources.inputs.DeploymentPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.resources.inputs.DeploymentPropertiesArgs =
        com.pulumi.azurenative.resources.inputs.DeploymentPropertiesArgs.builder()
            .debugSetting(debugSetting?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .expressionEvaluationOptions(
                expressionEvaluationOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .mode(mode.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .onErrorDeployment(onErrorDeployment?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .parametersLink(parametersLink?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .template(template?.applyValue({ args0 -> args0 }))
            .templateLink(templateLink?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DeploymentPropertiesArgs].
 */
@PulumiTagMarker
public class DeploymentPropertiesArgsBuilder internal constructor() {
    private var debugSetting: Output<DebugSettingArgs>? = null

    private var expressionEvaluationOptions: Output<ExpressionEvaluationOptionsArgs>? = null

    private var mode: Output<DeploymentMode>? = null

    private var onErrorDeployment: Output<OnErrorDeploymentArgs>? = null

    private var parameters: Output<Map<String, DeploymentParameterArgs>>? = null

    private var parametersLink: Output<ParametersLinkArgs>? = null

    private var template: Output<Any>? = null

    private var templateLink: Output<TemplateLinkArgs>? = null

    /**
     * @param value The debug setting of the deployment.
     */
    @JvmName("xgitdyqudddvtker")
    public suspend fun debugSetting(`value`: Output<DebugSettingArgs>) {
        this.debugSetting = value
    }

    /**
     * @param value Specifies whether template expressions are evaluated within the scope of the parent template or nested template. Only applicable to nested templates. If not specified, default value is outer.
     */
    @JvmName("seqgvnpoptrknerk")
    public suspend fun expressionEvaluationOptions(`value`: Output<ExpressionEvaluationOptionsArgs>) {
        this.expressionEvaluationOptions = value
    }

    /**
     * @param value The mode that is used to deploy resources. This value can be either Incremental or Complete. In Incremental mode, resources are deployed without deleting existing resources that are not included in the template. In Complete mode, resources are deployed and existing resources in the resource group that are not included in the template are deleted. Be careful when using Complete mode as you may unintentionally delete resources.
     */
    @JvmName("pjonhvkanigdbvwh")
    public suspend fun mode(`value`: Output<DeploymentMode>) {
        this.mode = value
    }

    /**
     * @param value The deployment on error behavior.
     */
    @JvmName("pkqeeiqvynemwmrn")
    public suspend fun onErrorDeployment(`value`: Output<OnErrorDeploymentArgs>) {
        this.onErrorDeployment = value
    }

    /**
     * @param value Name and value pairs that define the deployment parameters for the template. You use this element when you want to provide the parameter values directly in the request rather than link to an existing parameter file. Use either the parametersLink property or the parameters property, but not both. It can be a JObject or a well formed JSON string.
     */
    @JvmName("acmbdjvkbuxgvvyl")
    public suspend fun parameters(`value`: Output<Map<String, DeploymentParameterArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The URI of parameters file. You use this element to link to an existing parameters file. Use either the parametersLink property or the parameters property, but not both.
     */
    @JvmName("ywadsisiqjsibphu")
    public suspend fun parametersLink(`value`: Output<ParametersLinkArgs>) {
        this.parametersLink = value
    }

    /**
     * @param value The template content. You use this element when you want to pass the template syntax directly in the request rather than link to an existing template. It can be a JObject or well-formed JSON string. Use either the templateLink property or the template property, but not both.
     */
    @JvmName("jwluterakchkggsh")
    public suspend fun template(`value`: Output<Any>) {
        this.template = value
    }

    /**
     * @param value The URI of the template. Use either the templateLink property or the template property, but not both.
     */
    @JvmName("ialktukkmnbuwcmv")
    public suspend fun templateLink(`value`: Output<TemplateLinkArgs>) {
        this.templateLink = value
    }

    /**
     * @param value The debug setting of the deployment.
     */
    @JvmName("iksgjuaetpayjete")
    public suspend fun debugSetting(`value`: DebugSettingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.debugSetting = mapped
    }

    /**
     * @param argument The debug setting of the deployment.
     */
    @JvmName("kehajwjcvemaddrt")
    public suspend fun debugSetting(argument: suspend DebugSettingArgsBuilder.() -> Unit) {
        val toBeMapped = DebugSettingArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.debugSetting = mapped
    }

    /**
     * @param value Specifies whether template expressions are evaluated within the scope of the parent template or nested template. Only applicable to nested templates. If not specified, default value is outer.
     */
    @JvmName("xumbwegqpfpmdytu")
    public suspend fun expressionEvaluationOptions(`value`: ExpressionEvaluationOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expressionEvaluationOptions = mapped
    }

    /**
     * @param argument Specifies whether template expressions are evaluated within the scope of the parent template or nested template. Only applicable to nested templates. If not specified, default value is outer.
     */
    @JvmName("uqlrsdifbdafpfvw")
    public suspend
    fun expressionEvaluationOptions(argument: suspend ExpressionEvaluationOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = ExpressionEvaluationOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.expressionEvaluationOptions = mapped
    }

    /**
     * @param value The mode that is used to deploy resources. This value can be either Incremental or Complete. In Incremental mode, resources are deployed without deleting existing resources that are not included in the template. In Complete mode, resources are deployed and existing resources in the resource group that are not included in the template are deleted. Be careful when using Complete mode as you may unintentionally delete resources.
     */
    @JvmName("unjhcjwjvioqhwyy")
    public suspend fun mode(`value`: DeploymentMode) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The deployment on error behavior.
     */
    @JvmName("wlfesjptihqnomqh")
    public suspend fun onErrorDeployment(`value`: OnErrorDeploymentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onErrorDeployment = mapped
    }

    /**
     * @param argument The deployment on error behavior.
     */
    @JvmName("qwajevbcshpfxpci")
    public suspend fun onErrorDeployment(argument: suspend OnErrorDeploymentArgsBuilder.() -> Unit) {
        val toBeMapped = OnErrorDeploymentArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.onErrorDeployment = mapped
    }

    /**
     * @param value Name and value pairs that define the deployment parameters for the template. You use this element when you want to provide the parameter values directly in the request rather than link to an existing parameter file. Use either the parametersLink property or the parameters property, but not both. It can be a JObject or a well formed JSON string.
     */
    @JvmName("bhpujahbrxsiqwos")
    public suspend fun parameters(`value`: Map<String, DeploymentParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Name and value pairs that define the deployment parameters for the template. You use this element when you want to provide the parameter values directly in the request rather than link to an existing parameter file. Use either the parametersLink property or the parameters property, but not both. It can be a JObject or a well formed JSON string.
     */
    @JvmName("bqbipluxsnrkxpyk")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend DeploymentParameterArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                DeploymentParameterArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Name and value pairs that define the deployment parameters for the template. You use this element when you want to provide the parameter values directly in the request rather than link to an existing parameter file. Use either the parametersLink property or the parameters property, but not both. It can be a JObject or a well formed JSON string.
     */
    @JvmName("meeprmbmkjhswpya")
    public fun parameters(vararg values: Pair<String, DeploymentParameterArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The URI of parameters file. You use this element to link to an existing parameters file. Use either the parametersLink property or the parameters property, but not both.
     */
    @JvmName("bsxfxwihdbyfscwl")
    public suspend fun parametersLink(`value`: ParametersLinkArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parametersLink = mapped
    }

    /**
     * @param argument The URI of parameters file. You use this element to link to an existing parameters file. Use either the parametersLink property or the parameters property, but not both.
     */
    @JvmName("fgqkckejpdxhdepf")
    public suspend fun parametersLink(argument: suspend ParametersLinkArgsBuilder.() -> Unit) {
        val toBeMapped = ParametersLinkArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.parametersLink = mapped
    }

    /**
     * @param value The template content. You use this element when you want to pass the template syntax directly in the request rather than link to an existing template. It can be a JObject or well-formed JSON string. Use either the templateLink property or the template property, but not both.
     */
    @JvmName("xsfvgmqmlxbdofnr")
    public suspend fun template(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.template = mapped
    }

    /**
     * @param value The URI of the template. Use either the templateLink property or the template property, but not both.
     */
    @JvmName("jyqhtbuaaedhfyce")
    public suspend fun templateLink(`value`: TemplateLinkArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateLink = mapped
    }

    /**
     * @param argument The URI of the template. Use either the templateLink property or the template property, but not both.
     */
    @JvmName("ylkunnwhxwdnytld")
    public suspend fun templateLink(argument: suspend TemplateLinkArgsBuilder.() -> Unit) {
        val toBeMapped = TemplateLinkArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.templateLink = mapped
    }

    internal fun build(): DeploymentPropertiesArgs = DeploymentPropertiesArgs(
        debugSetting = debugSetting,
        expressionEvaluationOptions = expressionEvaluationOptions,
        mode = mode ?: throw PulumiNullFieldException("mode"),
        onErrorDeployment = onErrorDeployment,
        parameters = parameters,
        parametersLink = parametersLink,
        template = template,
        templateLink = templateLink,
    )
}
