@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.inputs

import com.pulumi.azurenative.resources.inputs.DeploymentStackPropertiesActionOnUnmanageArgs.builder
import com.pulumi.azurenative.resources.kotlin.enums.DeploymentStacksDeleteDetachEnum
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the behavior of resources that are not managed immediately after the stack is updated.
 * @property managementGroups Specifies the action that should be taken on the resource when the deployment stack is deleted. Delete will attempt to delete the resource from Azure. Detach will leave the resource in it's current state.
 * @property resourceGroups Specifies the action that should be taken on the resource when the deployment stack is deleted. Delete will attempt to delete the resource from Azure. Detach will leave the resource in it's current state.
 * @property resources Specifies the action that should be taken on the resource when the deployment stack is deleted. Delete will attempt to delete the resource from Azure. Detach will leave the resource in it's current state.
 */
public data class DeploymentStackPropertiesActionOnUnmanageArgs(
    public val managementGroups: Output<Either<String, DeploymentStacksDeleteDetachEnum>>? = null,
    public val resourceGroups: Output<Either<String, DeploymentStacksDeleteDetachEnum>>? = null,
    public val resources: Output<Either<String, DeploymentStacksDeleteDetachEnum>>,
) :
    ConvertibleToJava<com.pulumi.azurenative.resources.inputs.DeploymentStackPropertiesActionOnUnmanageArgs> {
    override fun toJava():
        com.pulumi.azurenative.resources.inputs.DeploymentStackPropertiesActionOnUnmanageArgs =
        com.pulumi.azurenative.resources.inputs.DeploymentStackPropertiesActionOnUnmanageArgs.builder()
            .managementGroups(
                managementGroups?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroups(
                resourceGroups?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resources(
                resources.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [DeploymentStackPropertiesActionOnUnmanageArgs].
 */
@PulumiTagMarker
public class DeploymentStackPropertiesActionOnUnmanageArgsBuilder internal constructor() {
    private var managementGroups: Output<Either<String, DeploymentStacksDeleteDetachEnum>>? = null

    private var resourceGroups: Output<Either<String, DeploymentStacksDeleteDetachEnum>>? = null

    private var resources: Output<Either<String, DeploymentStacksDeleteDetachEnum>>? = null

    /**
     * @param value Specifies the action that should be taken on the resource when the deployment stack is deleted. Delete will attempt to delete the resource from Azure. Detach will leave the resource in it's current state.
     */
    @JvmName("fueobrkvxalofqxf")
    public suspend
    fun managementGroups(`value`: Output<Either<String, DeploymentStacksDeleteDetachEnum>>) {
        this.managementGroups = value
    }

    /**
     * @param value Specifies the action that should be taken on the resource when the deployment stack is deleted. Delete will attempt to delete the resource from Azure. Detach will leave the resource in it's current state.
     */
    @JvmName("wxipemkiogflkngu")
    public suspend
    fun resourceGroups(`value`: Output<Either<String, DeploymentStacksDeleteDetachEnum>>) {
        this.resourceGroups = value
    }

    /**
     * @param value Specifies the action that should be taken on the resource when the deployment stack is deleted. Delete will attempt to delete the resource from Azure. Detach will leave the resource in it's current state.
     */
    @JvmName("ccnsobrknbjqhcck")
    public suspend fun resources(`value`: Output<Either<String, DeploymentStacksDeleteDetachEnum>>) {
        this.resources = value
    }

    /**
     * @param value Specifies the action that should be taken on the resource when the deployment stack is deleted. Delete will attempt to delete the resource from Azure. Detach will leave the resource in it's current state.
     */
    @JvmName("rsfloxdklnvukayh")
    public suspend fun managementGroups(`value`: Either<String, DeploymentStacksDeleteDetachEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managementGroups = mapped
    }

    /**
     * @param value Specifies the action that should be taken on the resource when the deployment stack is deleted. Delete will attempt to delete the resource from Azure. Detach will leave the resource in it's current state.
     */
    @JvmName("pcnsbpoayrkqwgwv")
    public fun managementGroups(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DeploymentStacksDeleteDetachEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.managementGroups = mapped
    }

    /**
     * @param value Specifies the action that should be taken on the resource when the deployment stack is deleted. Delete will attempt to delete the resource from Azure. Detach will leave the resource in it's current state.
     */
    @JvmName("crqlcwkuewumjjie")
    public fun managementGroups(`value`: DeploymentStacksDeleteDetachEnum) {
        val toBeMapped = Either.ofRight<String, DeploymentStacksDeleteDetachEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.managementGroups = mapped
    }

    /**
     * @param value Specifies the action that should be taken on the resource when the deployment stack is deleted. Delete will attempt to delete the resource from Azure. Detach will leave the resource in it's current state.
     */
    @JvmName("uddwfbuwgibhkxmb")
    public suspend fun resourceGroups(`value`: Either<String, DeploymentStacksDeleteDetachEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroups = mapped
    }

    /**
     * @param value Specifies the action that should be taken on the resource when the deployment stack is deleted. Delete will attempt to delete the resource from Azure. Detach will leave the resource in it's current state.
     */
    @JvmName("cxxgqajfskmvfjdv")
    public fun resourceGroups(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DeploymentStacksDeleteDetachEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceGroups = mapped
    }

    /**
     * @param value Specifies the action that should be taken on the resource when the deployment stack is deleted. Delete will attempt to delete the resource from Azure. Detach will leave the resource in it's current state.
     */
    @JvmName("btupuoxnerbebqtg")
    public fun resourceGroups(`value`: DeploymentStacksDeleteDetachEnum) {
        val toBeMapped = Either.ofRight<String, DeploymentStacksDeleteDetachEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceGroups = mapped
    }

    /**
     * @param value Specifies the action that should be taken on the resource when the deployment stack is deleted. Delete will attempt to delete the resource from Azure. Detach will leave the resource in it's current state.
     */
    @JvmName("lhmmctwnpslkerac")
    public suspend fun resources(`value`: Either<String, DeploymentStacksDeleteDetachEnum>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resources = mapped
    }

    /**
     * @param value Specifies the action that should be taken on the resource when the deployment stack is deleted. Delete will attempt to delete the resource from Azure. Detach will leave the resource in it's current state.
     */
    @JvmName("dtgadobdqdclnepw")
    public fun resources(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DeploymentStacksDeleteDetachEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resources = mapped
    }

    /**
     * @param value Specifies the action that should be taken on the resource when the deployment stack is deleted. Delete will attempt to delete the resource from Azure. Detach will leave the resource in it's current state.
     */
    @JvmName("hbwnucrtclaxpphi")
    public fun resources(`value`: DeploymentStacksDeleteDetachEnum) {
        val toBeMapped = Either.ofRight<String, DeploymentStacksDeleteDetachEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resources = mapped
    }

    internal fun build(): DeploymentStackPropertiesActionOnUnmanageArgs =
        DeploymentStackPropertiesActionOnUnmanageArgs(
            managementGroups = managementGroups,
            resourceGroups = resourceGroups,
            resources = resources ?: throw PulumiNullFieldException("resources"),
        )
}
