@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.inputs

import com.pulumi.azurenative.resources.inputs.ExpressionEvaluationOptionsArgs.builder
import com.pulumi.azurenative.resources.kotlin.enums.ExpressionEvaluationOptionsScopeType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies whether template expressions are evaluated within the scope of the parent template or nested template.
 * @property scope The scope to be used for evaluation of parameters, variables and functions in a nested template.
 */
public data class ExpressionEvaluationOptionsArgs(
    public val scope: Output<Either<String, ExpressionEvaluationOptionsScopeType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.resources.inputs.ExpressionEvaluationOptionsArgs> {
    override fun toJava(): com.pulumi.azurenative.resources.inputs.ExpressionEvaluationOptionsArgs =
        com.pulumi.azurenative.resources.inputs.ExpressionEvaluationOptionsArgs.builder()
            .scope(
                scope?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ExpressionEvaluationOptionsArgs].
 */
@PulumiTagMarker
public class ExpressionEvaluationOptionsArgsBuilder internal constructor() {
    private var scope: Output<Either<String, ExpressionEvaluationOptionsScopeType>>? = null

    /**
     * @param value The scope to be used for evaluation of parameters, variables and functions in a nested template.
     */
    @JvmName("baneejxokkqyirkd")
    public suspend fun scope(`value`: Output<Either<String, ExpressionEvaluationOptionsScopeType>>) {
        this.scope = value
    }

    /**
     * @param value The scope to be used for evaluation of parameters, variables and functions in a nested template.
     */
    @JvmName("uksrtyyavdbxbkhr")
    public suspend fun scope(`value`: Either<String, ExpressionEvaluationOptionsScopeType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value The scope to be used for evaluation of parameters, variables and functions in a nested template.
     */
    @JvmName("wbjqlneeweoiprfg")
    public fun scope(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ExpressionEvaluationOptionsScopeType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value The scope to be used for evaluation of parameters, variables and functions in a nested template.
     */
    @JvmName("lpkilqdquqbhgaug")
    public fun scope(`value`: ExpressionEvaluationOptionsScopeType) {
        val toBeMapped = Either.ofRight<String, ExpressionEvaluationOptionsScopeType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    internal fun build(): ExpressionEvaluationOptionsArgs = ExpressionEvaluationOptionsArgs(
        scope = scope,
    )
}
