@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.inputs

import com.pulumi.azurenative.resources.inputs.GetResourcePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property parentResourcePath The parent resource identity.
 * @property resourceGroupName The name of the resource group containing the resource to get. The name is case insensitive.
 * @property resourceName The name of the resource to get.
 * @property resourceProviderNamespace The namespace of the resource provider.
 * @property resourceType The resource type of the resource.
 */
public data class GetResourcePlainArgs(
    public val parentResourcePath: String,
    public val resourceGroupName: String,
    public val resourceName: String,
    public val resourceProviderNamespace: String,
    public val resourceType: String,
) : ConvertibleToJava<com.pulumi.azurenative.resources.inputs.GetResourcePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.resources.inputs.GetResourcePlainArgs =
        com.pulumi.azurenative.resources.inputs.GetResourcePlainArgs.builder()
            .parentResourcePath(parentResourcePath.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 }))
            .resourceProviderNamespace(resourceProviderNamespace.let({ args0 -> args0 }))
            .resourceType(resourceType.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetResourcePlainArgs].
 */
@PulumiTagMarker
public class GetResourcePlainArgsBuilder internal constructor() {
    private var parentResourcePath: String? = null

    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    private var resourceProviderNamespace: String? = null

    private var resourceType: String? = null

    /**
     * @param value The parent resource identity.
     */
    @JvmName("onhafequhmsrglsv")
    public suspend fun parentResourcePath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.parentResourcePath = mapped
    }

    /**
     * @param value The name of the resource group containing the resource to get. The name is case insensitive.
     */
    @JvmName("vjdmlpdnsdwyxuga")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the resource to get.
     */
    @JvmName("uweqirsmgnhalkij")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    /**
     * @param value The namespace of the resource provider.
     */
    @JvmName("xrpcyvmdrrmyftjw")
    public suspend fun resourceProviderNamespace(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceProviderNamespace = mapped
    }

    /**
     * @param value The resource type of the resource.
     */
    @JvmName("sjangecjxwslnvgn")
    public suspend fun resourceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceType = mapped
    }

    internal fun build(): GetResourcePlainArgs = GetResourcePlainArgs(
        parentResourcePath = parentResourcePath ?: throw PulumiNullFieldException("parentResourcePath"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
        resourceProviderNamespace = resourceProviderNamespace ?: throw
            PulumiNullFieldException("resourceProviderNamespace"),
        resourceType = resourceType ?: throw PulumiNullFieldException("resourceType"),
    )
}
