@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.inputs

import com.pulumi.azurenative.resources.inputs.StorageAccountConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Settings to use an existing storage account. Valid storage account kinds are: Storage, StorageV2 and FileStorage
 * @property storageAccountKey The storage account access key.
 * @property storageAccountName The storage account name.
 */
public data class StorageAccountConfigurationArgs(
    public val storageAccountKey: Output<String>? = null,
    public val storageAccountName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.resources.inputs.StorageAccountConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.resources.inputs.StorageAccountConfigurationArgs =
        com.pulumi.azurenative.resources.inputs.StorageAccountConfigurationArgs.builder()
            .storageAccountKey(storageAccountKey?.applyValue({ args0 -> args0 }))
            .storageAccountName(storageAccountName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StorageAccountConfigurationArgs].
 */
@PulumiTagMarker
public class StorageAccountConfigurationArgsBuilder internal constructor() {
    private var storageAccountKey: Output<String>? = null

    private var storageAccountName: Output<String>? = null

    /**
     * @param value The storage account access key.
     */
    @JvmName("bcatqjoxgvkjcoog")
    public suspend fun storageAccountKey(`value`: Output<String>) {
        this.storageAccountKey = value
    }

    /**
     * @param value The storage account name.
     */
    @JvmName("ppiwpsaydjykvxvr")
    public suspend fun storageAccountName(`value`: Output<String>) {
        this.storageAccountName = value
    }

    /**
     * @param value The storage account access key.
     */
    @JvmName("fkggajefxeoimrmt")
    public suspend fun storageAccountKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountKey = mapped
    }

    /**
     * @param value The storage account name.
     */
    @JvmName("tlkoglobwdhstlkt")
    public suspend fun storageAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountName = mapped
    }

    internal fun build(): StorageAccountConfigurationArgs = StorageAccountConfigurationArgs(
        storageAccountKey = storageAccountKey,
        storageAccountName = storageAccountName,
    )
}
